/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.domain.Comment;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.IssueEstimation;
import org.jboss.set.aphrodite.domain.IssuePriority;
import org.jboss.set.aphrodite.domain.IssueStatus;
import org.jboss.set.aphrodite.domain.IssueType;
import org.jboss.set.aphrodite.domain.Release;
import org.jboss.set.aphrodite.domain.Stage;
import org.jboss.set.aphrodite.domain.User;

public class Issue {
    private URL url;
    private String trackerId;
    private final TrackerType trackerType;
    private String product;
    private List<String> components;
    private String summary;
    private String description;
    private User assignee;
    private User reporter;
    private Stage stage;
    private IssueStatus status;
    private IssuePriority priority;
    private IssueType type;
    private List<Release> releases;
    private Map<String, FlagStatus> streamStatus;
    private List<URL> dependsOn;
    private List<URL> blocks;
    private Date creationTime;
    private Date lastUpdated;
    private IssueEstimation estimation;
    private List<Comment> comments;

    public Issue(URL url, TrackerType type) {
        if (url == null) {
            throw new IllegalArgumentException("Issue URL cannot be null");
        }
        this.url = url;
        this.trackerType = type;
        this.stage = new Stage();
        this.status = IssueStatus.UNDEFINED;
        this.type = IssueType.UNDEFINED;
        this.releases = new ArrayList<Release>();
        this.streamStatus = new HashMap<String, FlagStatus>();
        this.dependsOn = new ArrayList<URL>();
        this.blocks = new ArrayList<URL>();
        this.comments = new ArrayList<Comment>();
        this.components = new ArrayList<String>();
    }

    public URL getURL() {
        return this.url;
    }

    public Optional<String> getTrackerId() {
        return Optional.ofNullable(this.trackerId);
    }

    public void setTrackerId(String trackerId) {
        this.trackerId = trackerId;
    }

    public TrackerType getTrackerType() {
        return this.trackerType;
    }

    public Optional<String> getProduct() {
        return Optional.ofNullable(this.product);
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public void setComponents(List<String> components) {
        this.components = components;
    }

    public Optional<String> getSummary() {
        return Optional.ofNullable(this.summary);
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Optional<User> getAssignee() {
        return Optional.ofNullable(this.assignee);
    }

    public void setAssignee(User assignee) {
        this.assignee = assignee;
    }

    public Optional<User> getReporter() {
        return Optional.ofNullable(this.reporter);
    }

    public void setReporter(User reporter) {
        this.reporter = reporter;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        Objects.requireNonNull(stage, "An Issue's stage cannot be set to null");
        this.stage = stage;
    }

    public IssueStatus getStatus() {
        return this.status;
    }

    public void setStatus(IssueStatus status) {
        Objects.requireNonNull(status, "An Issue's status cannot be set to null");
        this.status = status;
    }

    public IssuePriority getPriority() {
        return this.priority;
    }

    public void setPriority(IssuePriority priority) {
        Objects.requireNonNull(this.status, "An Issue's priority cannot be set to null");
        this.priority = priority;
    }

    public IssueType getType() {
        return this.type;
    }

    public void setType(IssueType type) {
        Objects.requireNonNull(type, "An Issue's Type cannot be set to null");
        this.type = type;
    }

    public List<Release> getReleases() {
        return this.releases;
    }

    public void setReleases(List<Release> releases) {
        Objects.requireNonNull(releases, "An Issue's Release cannot be set to null");
        this.releases = releases;
    }

    public Map<String, FlagStatus> getStreamStatus() {
        return this.streamStatus;
    }

    public void setStreamStatus(Map<String, FlagStatus> streamStatus) {
        Objects.requireNonNull(streamStatus, "An Issue's StreamStatus cannot be set to null");
        this.streamStatus = streamStatus;
    }

    public List<URL> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<URL> dependsOn) {
        Objects.requireNonNull(dependsOn, "An Issue's DependsOn List cannot be set to null");
        this.dependsOn = dependsOn;
    }

    public List<URL> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<URL> blocks) {
        Objects.requireNonNull(blocks, "An Issue's Blocks List cannot be set to null");
        this.blocks = blocks;
    }

    public Optional<Date> getCreationTime() {
        return Optional.ofNullable(this.creationTime);
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(this.lastUpdated);
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Optional<IssueEstimation> getEstimation() {
        return Optional.ofNullable(this.estimation);
    }

    public void setEstimation(IssueEstimation estimation) {
        this.estimation = estimation;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        Objects.requireNonNull(comments, "An Issue's Comments cannot be set to null");
        this.comments = comments;
    }

    public String toString() {
        return "Issue{url=" + this.url + ", trackerId='" + this.trackerId + '\'' + ", trackerType='" + (Object)((Object)this.trackerType) + '\'' + ", product='" + this.product + '\'' + ", component='" + this.components + '\'' + ", summary='" + this.summary + '\'' + ", description='" + this.getPrintableDescription() + '\'' + ", assignee='" + this.assignee + '\'' + ", reporter='" + this.reporter + '\'' + ", stage=" + this.stage + ", status=" + (Object)((Object)this.status) + ", priority=" + (Object)((Object)this.priority) + ", type=" + (Object)((Object)this.type) + ", release=" + this.releases + ", streamStatus=" + this.streamStatus + ", dependsOn=" + this.dependsOn + ", blocks=" + this.blocks + ", creationDate=" + this.creationTime + ", lastUpdated=" + this.lastUpdated + ", estimation=" + this.estimation + ", #comments=" + this.comments.size() + "}\n";
    }

    private String getPrintableDescription() {
        if (this.description == null) {
            return "";
        }
        if (this.description.length() < 10) {
            return this.description + "... ";
        }
        return this.description.substring(0, 10) + "... ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return this.url.equals(issue.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }
}

