/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.util.Optional;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Repository;

public class StreamComponent {
    private final String name;
    private final Repository repository;
    private final Codebase codebase;

    public StreamComponent(String name, Repository repository, Codebase codebase) {
        this.name = name.toLowerCase();
        this.repository = repository;
        this.codebase = codebase;
    }

    public String getName() {
        return this.name;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Codebase getCodebase() {
        return this.codebase;
    }

    public Optional<String> getCodeBasePath() {
        String url = this.repository.getURL().toExternalForm();
        System.out.println(url);
        if (url.contains("github.com")) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            return Optional.of(url + "tree/" + this.codebase.getName());
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamComponent streamComponent = (StreamComponent)o;
        return this.name.equals(streamComponent.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "StreamComponent{name='" + this.name + '\'' + ", repository=" + this.repository + ", codebase=" + this.codebase + '}';
    }
}

