/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Filter;
import com.atlassian.jira.rest.client.api.domain.IssueLink;
import com.atlassian.jira.rest.client.api.domain.IssueLinkType;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.LinkIssuesInput;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.IssueTrackerConfig;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.SearchCriteria;
import org.jboss.set.aphrodite.issue.trackers.common.AbstractIssueTracker;
import org.jboss.set.aphrodite.issue.trackers.jira.IssueWrapper;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraFields;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraQueryBuilder;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class JiraIssueTracker
extends AbstractIssueTracker {
    private static final Log LOG = LogFactory.getLog(JiraIssueTracker.class);
    private final IssueWrapper WRAPPER = new IssueWrapper();
    private final JiraQueryBuilder queryBuilder = new JiraQueryBuilder();
    private JiraRestClient restClient;

    public JiraIssueTracker() {
        super(TrackerType.JIRA);
    }

    @Override
    public boolean init(IssueTrackerConfig config) {
        boolean parentInitiated = super.init(config);
        if (!parentInitiated) {
            return false;
        }
        try {
            AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
            URI jiraServerUri = this.baseUrl.toURI();
            this.restClient = factory.createWithBasicHttpAuthentication(jiraServerUri, config.getUsername(), config.getPassword());
        }
        catch (Exception e) {
            Utils.logException(LOG, e);
            return false;
        }
        return true;
    }

    @Override
    public Issue getIssue(URL url) throws NotFoundException {
        String issueKey = this.getIssueKey(url);
        try {
            this.checkHost(url);
            com.atlassian.jira.rest.client.api.domain.Issue issue = (com.atlassian.jira.rest.client.api.domain.Issue)this.restClient.getIssueClient().getIssue(issueKey).get();
            return this.WRAPPER.jiraIssueToIssue(url, issue);
        }
        catch (InterruptedException e) {
            throw new NotFoundException("Something interrupted the execution when trying to retrieve issue " + issueKey, e);
        }
        catch (ExecutionException e) {
            throw new NotFoundException("Unable to retrieve issue with id: " + issueKey, e);
        }
    }

    private com.atlassian.jira.rest.client.api.domain.Issue getIssue(Issue issue) throws NotFoundException {
        String trackerId = issue.getTrackerId().orElse(this.getIssueKey(issue.getURL()));
        return this.getIssue(trackerId);
    }

    private com.atlassian.jira.rest.client.api.domain.Issue getIssue(String trackerId) throws NotFoundException {
        try {
            return (com.atlassian.jira.rest.client.api.domain.Issue)this.restClient.getIssueClient().getIssue(trackerId).get();
        }
        catch (Exception e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public List<Issue> getIssues(Collection<URL> urls) {
        if ((urls = this.filterUrlsByHost(urls)).isEmpty()) {
            return new ArrayList<Issue>();
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (URL url : urls) {
            try {
                ids.add(this.getIssueKey(url));
            }
            catch (NotFoundException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Unable to extract trackerId from: " + url);
            }
        }
        String jql = this.queryBuilder.getMultipleIssueJQL(ids);
        return this.searchIssues(jql, ids.size());
    }

    @Override
    public List<Issue> searchIssues(SearchCriteria searchCriteria) {
        String jql = this.queryBuilder.getSearchJQL(searchCriteria);
        int maxResults = searchCriteria.getMaxResults().orElse(this.config.getDefaultIssueLimit());
        return this.searchIssues(jql, maxResults);
    }

    private List<Issue> searchIssues(String jql, int maxResults) {
        try {
            ArrayList<Issue> issues = new ArrayList<Issue>();
            SearchRestClient searchClient = this.restClient.getSearchClient();
            HashSet<String> fields = new HashSet<String>();
            fields.add("*all");
            SearchResult result = (SearchResult)searchClient.searchJql(jql, maxResults, null, fields).get();
            result.getIssues().forEach(issue -> issues.add(this.WRAPPER.jiraSearchIssueToIssue(this.baseUrl, (com.atlassian.jira.rest.client.api.domain.Issue)issue)));
            return issues;
        }
        catch (Exception e) {
            LOG.error("Problem executing jql " + jql, e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Issue> searchIssuesByFilter(URL filterUrl) throws NotFoundException {
        String jql = this.getJQLFromFilter(filterUrl);
        return this.searchIssues(jql, this.config.getDefaultIssueLimit());
    }

    private String getJQLFromFilter(URL filterUrl) throws NotFoundException {
        try {
            SearchRestClient searchClient = this.restClient.getSearchClient();
            Filter filter = (Filter)searchClient.getFilter(filterUrl.toURI()).get();
            return filter.getJql();
        }
        catch (Exception e) {
            throw new NotFoundException("Unable to retrieve filter with url: " + filterUrl, e);
        }
    }

    @Override
    public boolean updateIssue(Issue issue) throws NotFoundException, AphroditeException {
        try {
            this.checkHost(issue.getURL());
            com.atlassian.jira.rest.client.api.domain.Issue jiraIssue = this.getIssue(issue);
            Project project = this.restClient.getProjectClient().getProject(jiraIssue.getProject().getSelf()).claim();
            IssueInput update = this.WRAPPER.issueToFluentUpdate(issue, jiraIssue, project);
            IssueRestClient issueClient = this.restClient.getIssueClient();
            issueClient.updateIssue(jiraIssue.getKey(), update).claim();
            if (!JiraFields.hasSameIssueStatus(issue, jiraIssue)) {
                String transition = JiraFields.getJiraTransition(issue, jiraIssue);
                for (Transition t : (Iterable)issueClient.getTransitions(jiraIssue).get()) {
                    if (!t.getName().equals(transition)) continue;
                    issueClient.transition(jiraIssue, new TransitionInput(t.getId())).claim();
                }
            }
            for (LinkIssuesInput linkIssuesInput : this.calculateNewLinks(issue, jiraIssue)) {
                issueClient.linkIssue(linkIssuesInput).claim();
            }
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AphroditeException(this.getUpdateErrorMessage(issue, e), e);
        }
    }

    private List<LinkIssuesInput> calculateNewLinks(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        Iterable<IssueLink> jiraIssueLinks = jiraIssue.getIssueLinks();
        if (jiraIssueLinks == null) {
            return new ArrayList<LinkIssuesInput>();
        }
        List<IssueLink> tmp = StreamSupport.stream(jiraIssueLinks.spliterator(), false).collect(Collectors.toList());
        List<String> inbound = this.getExistingIssueLinkKeys(tmp, IssueLinkType.Direction.INBOUND);
        List<String> outbound = this.getExistingIssueLinkKeys(tmp, IssueLinkType.Direction.OUTBOUND);
        return Stream.concat(this.createIssueLinks(issue, inbound, e -> new LinkIssuesInput((String)e, jiraIssue.getKey(), "Dependency")), this.createIssueLinks(issue, outbound, e -> new LinkIssuesInput(jiraIssue.getKey(), (String)e, "Dependency"))).collect(Collectors.toList());
    }

    private Stream<LinkIssuesInput> createIssueLinks(Issue issue, List<String> existingLinks, Function<String, LinkIssuesInput> createLink) {
        return issue.getBlocks().stream().map(this::toKey).filter(e -> !e.isEmpty() && !existingLinks.contains(e)).map(createLink);
    }

    private List<String> getExistingIssueLinkKeys(List<IssueLink> issueLinks, IssueLinkType.Direction linkDirection) {
        return issueLinks.stream().filter(link -> link.getIssueLinkType().getDirection().equals((Object)linkDirection)).filter(link -> link.getIssueLinkType().getName().equals("Dependency")).map(IssueLink::getTargetIssueKey).collect(Collectors.toList());
    }

    private String toKey(URL url) {
        try {
            return this.getIssueKey(url);
        }
        catch (NotFoundException e) {
            return "";
        }
    }

    @Override
    public void addCommentToIssue(Issue issue, org.jboss.set.aphrodite.domain.Comment comment) throws NotFoundException {
        super.addCommentToIssue(issue, comment);
        this.postComment(issue, comment);
    }

    private void postComment(Issue issue, org.jboss.set.aphrodite.domain.Comment comment) throws NotFoundException {
        if (comment.isPrivate()) {
            Utils.logWarnMessage(LOG, "Private comments are not currently supported by " + this.getClass().getName());
        }
        com.atlassian.jira.rest.client.api.domain.Issue jiraIssue = this.getIssue(issue);
        Comment c = Comment.valueOf(comment.getBody());
        this.restClient.getIssueClient().addComment(jiraIssue.getCommentsUri(), c).claim();
    }

    @Override
    public boolean addCommentToIssue(Map<Issue, org.jboss.set.aphrodite.domain.Comment> commentMap) {
        commentMap = this.filterIssuesByHost(commentMap);
        List requests = commentMap.entrySet().stream().map(entry -> CompletableFuture.supplyAsync(() -> this.postCommentAndLogExceptions((Issue)entry.getKey(), (org.jboss.set.aphrodite.domain.Comment)entry.getValue()), this.executorService)).collect(Collectors.toList());
        return requests.stream().map(CompletableFuture::join).noneMatch(failed -> failed == false);
    }

    @Override
    public boolean addCommentToIssue(Collection<Issue> issues, org.jboss.set.aphrodite.domain.Comment comment) {
        issues = this.filterIssuesByHost(issues);
        List requests = issues.stream().map(issue -> CompletableFuture.supplyAsync(() -> this.postCommentAndLogExceptions((Issue)issue, comment), this.executorService)).collect(Collectors.toList());
        return requests.stream().map(CompletableFuture::join).noneMatch(failed -> failed == false);
    }

    private boolean postCommentAndLogExceptions(Issue issue, org.jboss.set.aphrodite.domain.Comment comment) {
        try {
            this.postComment(issue, comment);
            return true;
        }
        catch (NotFoundException e) {
            Utils.logException(LOG, e);
            return false;
        }
    }

    @Override
    public Log getLog() {
        return LOG;
    }

    private String getIssueKey(URL url) throws NotFoundException {
        String path = url.getPath();
        boolean api = path.contains("/rest/api/2/issue/");
        boolean browse = path.contains("/browse/");
        if (!api && !browse) {
            throw new NotFoundException("The URL path must be of the form '/rest/api/2/issue/' OR '/browse/'");
        }
        return api ? path.substring("/rest/api/2/issue/".length()) : path.substring("/browse/".length());
    }

    private String getUpdateErrorMessage(Issue issue, Exception e) {
        String msg = e.getMessage();
        if (msg.contains("does not exist or read-only")) {
            for (Map.Entry entry : JiraFields.FLAG_MAP.entrySet()) {
                if (!msg.contains((CharSequence)entry.getValue())) continue;
                String retMsg = "Flag '%1$s' set in Issue.stage cannot be set for %2$s '%3$s'";
                return this.getOptionalErrorMessage(retMsg, issue.getProduct(), entry.getKey(), issue.getURL());
            }
            if (msg.contains("12311240")) {
                String retMsg = "Release.milestone cannot be set for %2$s ''%3$s'";
                return this.getOptionalErrorMessage(retMsg, issue.getProduct(), null, issue.getURL());
            }
        }
        return null;
    }

    private String getOptionalErrorMessage(String template, Optional<?> optional, Object val, URL url) {
        if (optional.isPresent()) {
            return String.format(template, val, "issues in project", optional.get());
        }
        return String.format(template, val, "issue at ", url);
    }

    @Override
    public void destroy() {
        try {
            this.restClient.close();
        }
        catch (IOException e) {
            LOG.warn("destroyin jira issue tracker", e);
        }
    }
}

