/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.github;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.PatchState;
import org.jboss.set.aphrodite.domain.Repository;

class GitHubWrapper {
    GitHubWrapper() {
    }

    Repository toAphroditeRepository(URL url, List<RepositoryBranch> branches) {
        Repository repo = new Repository(url);
        List branchNames = branches.stream().map(this::repositoryBranchToCodebase).collect(Collectors.toList());
        repo.getCodebases().addAll(branchNames);
        return repo;
    }

    List<Patch> toAphroditePatches(List<PullRequest> pullRequests) {
        return pullRequests.stream().map(this::pullRequestToPatch).collect(Collectors.toList());
    }

    Patch pullRequestToPatch(PullRequest pullRequest) {
        try {
            String id = Integer.toString(pullRequest.getNumber());
            URL url = new URL(pullRequest.getHtmlUrl());
            Codebase codebase = new Codebase(pullRequest.getBase().getRef());
            PatchState state = this.getPatchState(pullRequest.getState());
            String title = pullRequest.getTitle().replaceFirst("\\u2026", "");
            String body = pullRequest.getBody().replaceFirst("\\u2026", "");
            String urlString = url.toString();
            int idx = urlString.indexOf("pull");
            if (idx >= 0) {
                urlString = urlString.substring(0, idx);
            }
            Repository repo = new Repository(URI.create(urlString).toURL());
            return new Patch(id, url, repo, codebase, state, title, body);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public List<Label> pullRequestLabeltoPatchLabel(List<org.eclipse.egit.github.core.Label> labels) {
        ArrayList<Label> patchLabels = new ArrayList<Label>();
        for (org.eclipse.egit.github.core.Label label : labels) {
            String name = label.getName();
            String color = label.getColor();
            String url = label.getUrl();
            patchLabels.add(new Label(color, name, url));
        }
        return patchLabels;
    }

    private PatchState getPatchState(String state) {
        try {
            return PatchState.valueOf(state.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return PatchState.UNDEFINED;
        }
    }

    private Codebase repositoryBranchToCodebase(RepositoryBranch branch) {
        return new Codebase(branch.getName());
    }
}

