/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.bugzilla;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.PatchState;
import org.jboss.set.aphrodite.domain.PatchType;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.spi.PatchHome;
import org.jboss.set.aphrodite.repository.services.common.RepositoryUtils;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class BugzillaPatchHomeImpl
implements PatchHome {
    private static final Log logger = LogFactory.getLog(BugzillaPatchHomeImpl.class);

    public Stream<Patch> findPatchesByIssue(Issue issue) {
        ArrayList<URL> urls = new ArrayList<URL>();
        issue.getComments().stream().forEach(e -> this.extractPullRequests(urls, e.getBody()));
        return this.mapURLtoPatchStream(urls);
    }

    private void extractPullRequests(List<URL> pullRequests, String messageBody) {
        Matcher matcher = RepositoryUtils.RELATED_PR_PATTERN.matcher(messageBody);
        while (matcher.find()) {
            if (matcher.groupCount() != 3) continue;
            String urlStr = "https://github.com/" + matcher.group(1) + "/" + matcher.group(2) + "/pull/" + matcher.group(3);
            try {
                URL url = new URL(urlStr);
                pullRequests.add(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL:" + urlStr, e);
            }
        }
    }

    private Stream<Patch> mapURLtoPatchStream(List<URL> urls) {
        return urls.stream().map(e -> {
            PatchType patchType = this.getPatchType((URL)e);
            PatchState patchState = this.getPatchState((URL)e, patchType);
            return new Patch(e, this.getPatchType((URL)e), patchState);
        });
    }

    private PatchType getPatchType(URL url) {
        String urlStr = url.toString();
        if (urlStr.contains("/pull/")) {
            return PatchType.PULLREQUEST;
        }
        if (urlStr.contains("/commit/")) {
            return PatchType.COMMIT;
        }
        return PatchType.FILE;
    }

    private PatchState getPatchState(URL url, PatchType patchType) {
        if (patchType.equals((Object)PatchType.PULLREQUEST)) {
            try {
                PullRequest pullRequest = Aphrodite.instance().getPullRequest(url);
                return PatchState.valueOf((String)pullRequest.getState().toString());
            }
            catch (NotFoundException e) {
                Utils.logException((Log)logger, (String)("Unable to find pull request with url: " + url), (Exception)((Object)e));
            }
            catch (AphroditeException e) {
                Utils.logException((Log)logger, (Exception)((Object)e));
            }
        } else if (patchType.equals((Object)PatchType.COMMIT)) {
            return PatchState.CLOSED;
        }
        return PatchState.UNDEFINED;
    }
}

