/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.rest;

import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.TestCompositeVDB;
import org.teiid.jboss.rest.RestASMBasedWebArchiveBuilder;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.TestDDLParser;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestRestWebArchiveBuilder {
    private VDBMetaData getTestVDBMetaData() throws FileNotFoundException, XMLStreamException {
        VDBMetaData vdb = VDBMetadataParser.unmarshell((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"sample-vdb.xml")));
        MetadataStore ms = new MetadataStore();
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            MetadataFactory mf = TestDDLParser.helpParse((String)model.getSchemaText(), (String)model.getName());
            ms.addSchema(mf.getSchema());
        }
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)ms, (String)"Rest", (FunctionTree[])new FunctionTree[0]);
        vdb.addAttchment(QueryMetadataInterface.class, (Object)metadata);
        vdb.addAttchment(TransformationMetadata.class, (Object)metadata);
        vdb.addAttchment(MetadataStore.class, (Object)ms);
        return vdb;
    }

    @Test
    public void testBuildArchive() throws Exception {
        ZipEntry ze;
        VDBMetaData vdb = this.getTestVDBMetaData();
        RestASMBasedWebArchiveBuilder builder = new RestASMBasedWebArchiveBuilder();
        byte[] contents = builder.getContent(vdb);
        ArrayList<String> files = new ArrayList<String>();
        files.add("WEB-INF/web.xml");
        files.add("WEB-INF/jboss-web.xml");
        files.add("WEB-INF/classes/org/teiid/jboss/rest/View.class");
        files.add("WEB-INF/classes/org/teiid/jboss/rest/TeiidRestApplication.class");
        files.add("WEB-INF/classes/org/teiid/jboss/rest/Bootstrap.class");
        files.add("META-INF/MANIFEST.MF");
        files.add("api.html");
        files.add("images/teiid_logo_450px.png");
        files.add("swagger/swagger-ui.js");
        files.add("swagger/css/print.css");
        files.add("swagger/css/reset.css");
        files.add("swagger/css/screen.css");
        files.add("swagger/css/style.css");
        files.add("swagger/css/typography.css");
        files.add("swagger/images/favicon-16x16.png");
        files.add("swagger/images/favicon-32x32.png");
        files.add("swagger/lang/en.js");
        files.add("swagger/lang/es.js");
        files.add("swagger/lang/pt.js");
        files.add("swagger/lang/ru.js");
        files.add("swagger/lang/translator.js");
        files.add("swagger/lib/backbone-min.js");
        files.add("swagger/lib/handlebars-2.0.0.js");
        files.add("swagger/lib/highlight.7.3.pack.js");
        files.add("swagger/lib/jquery-1.8.0.min.js");
        files.add("swagger/lib/jquery.ba-bbq.min.js");
        files.add("swagger/lib/jquery.slideto.min.js");
        files.add("swagger/lib/jquery.wiggle.min.js");
        files.add("swagger/lib/marked.js");
        files.add("swagger/lib/swagger-oauth.js");
        files.add("swagger/lib/underscore-min.js");
        files.add("swagger/lib/underscore-min.map");
        ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(contents));
        while ((ze = zipIn.getNextEntry()) != null) {
            Assert.assertTrue((boolean)files.contains(ze.getName()));
            zipIn.closeEntry();
        }
    }

    @Test
    public void testBuildArchiveSwagger() throws Exception {
        VDBMetaData vdb = this.getTestVDBMetaData();
        RestASMBasedWebArchiveBuilder builder = new RestASMBasedWebArchiveBuilder();
        CompositeMetadataStore metadataStore = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            Schema schema = metadataStore.getSchema(model.getName());
            byte[] viewContents = builder.getViewClass(vdb.getName(), vdb.getVersion(), model.getName(), schema, false);
            if (viewContents == null) continue;
            Class<?> cls = ASMUtilities.defineClass("org.teiid.jboss.rest.View", viewContents);
            HashSet<Annotation> annotationSet = new HashSet<Annotation>();
            for (Annotation annotation : cls.getAnnotations()) {
                annotationSet.add(annotation);
            }
            Assert.assertEquals((long)2L, (long)annotationSet.size());
            for (Method m : cls.getMethods()) {
                ApiOperation annotation;
                if (m.getName().equals("g1Tableapplication_xml")) {
                    annotation = m.getAnnotation(ApiOperation.class);
                    Assert.assertEquals((Object)"g1Table", (Object)annotation.value());
                    continue;
                }
                if (m.getName().equals("sqlQueryxml")) {
                    annotation = m.getAnnotation(ApiOperation.class);
                    Assert.assertEquals((Object)"xml", (Object)annotation.value());
                    continue;
                }
                if (!m.getName().equals("sqlQueryjson")) continue;
                annotation = m.getAnnotation(ApiOperation.class);
                Assert.assertEquals((Object)"json", (Object)annotation.value());
            }
        }
    }

    @Test
    public void testBootstrapServletClass() throws InstantiationException, IllegalAccessException {
        RestASMBasedWebArchiveBuilder builder = new RestASMBasedWebArchiveBuilder();
        byte[] bytes = builder.getBootstrapServletClass("vdbName", "", "version", new String[]{"http"}, "baseUrl", "packages", Boolean.valueOf(true));
        Class<?> cls = ASMUtilities.defineClass("org.teiid.jboss.rest.Bootstrap", bytes);
        Object obj = cls.newInstance();
        Assert.assertEquals(cls, obj.getClass());
    }

    @Test
    public void testOtherModels() throws Exception {
        MetadataStore ms = new MetadataStore();
        CompositeVDB vdb = TestCompositeVDB.createCompositeVDB((MetadataStore)ms, (String)"x");
        vdb.getVDB().addProperty("{http://teiid.org/rest}auto-generate", "true");
        ModelMetaData model = new ModelMetaData();
        model.setName("other");
        model.setModelType(Model.Type.OTHER);
        vdb.getVDB().addModel(model);
        RestASMBasedWebArchiveBuilder builder = new RestASMBasedWebArchiveBuilder();
        builder.getContent(vdb.getVDB());
    }

    private static class ASMUtilities {
        private ASMUtilities() {
        }

        public static Class<?> defineClass(String name, byte[] bytes) {
            return new TestClassLoader(TestClassLoader.class.getClassLoader()).defineClassForName(name, bytes);
        }

        private static class TestClassLoader
        extends ClassLoader {
            public TestClassLoader(ClassLoader classLoader) {
                super(classLoader);
            }

            public Class<?> defineClassForName(String name, byte[] data) {
                return this.defineClass(name, data, 0, data.length);
            }
        }
    }
}

