/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;

public class DeserializationUtils {
    public static JsonNode deserializeIntoTree(String contents, String fileOrHost) {
        JsonNode result;
        try {
            result = fileOrHost.endsWith(".yaml") ? Yaml.mapper().readTree(contents) : Json.mapper().readTree(contents);
        }
        catch (IOException e) {
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into a JsonNode tree", e);
        }
        return result;
    }

    public static <T> T deserialize(Object contents, String fileOrHost, Class<T> expectedType) {
        Object result;
        ObjectMapper mapper = fileOrHost.endsWith(".yaml") ? Yaml.mapper() : Json.mapper();
        try {
            result = contents instanceof String ? mapper.readValue((String)contents, expectedType) : mapper.convertValue(contents, expectedType);
        }
        catch (IOException e) {
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into type " + expectedType, e);
        }
        return (T)result;
    }
}

