/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.rest;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ModelController;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.ContainerLifeCycleListener;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.jboss.rest.RestASMBasedWebArchiveBuilder;
import org.teiid.jboss.rest.RestServicePlugin;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.vdb.runtime.VDBKey;

public class ResteasyEnabler
implements VDBLifeCycleListener {
    static final String REST_NAMESPACE = "{http://teiid.org/rest}";
    private AdminFactory.AdminImpl admin;
    private Executor executor;
    private VDBKey vdbKey;
    private AtomicBoolean deployed = new AtomicBoolean(false);

    public ResteasyEnabler(String vdbName, String version, ModelController deployer, Executor executor, ContainerLifeCycleListener shutdownListener) {
        this.admin = (AdminFactory.AdminImpl)AdminFactory.getInstance().createAdmin(deployer.createClient(executor));
        this.executor = executor;
        this.vdbKey = new VDBKey(vdbName, (Object)version);
    }

    public synchronized void added(String name, CompositeVDB vdb) {
    }

    public void beforeRemove(String name, CompositeVDB cvdb) {
        this.deployed.set(false);
    }

    public synchronized void finishedDeployment(String name, CompositeVDB cvdb) {
        if (cvdb.getVDBKey().equals((Object)this.vdbKey)) {
            final VDBMetaData vdb = cvdb.getVDB();
            if (!vdb.getStatus().equals((Object)VDB.Status.ACTIVE)) {
                return;
            }
            String generate = vdb.getPropertyValue("{http://teiid.org/rest}auto-generate");
            final String warName = this.buildName(name, cvdb.getVDB().getVersion());
            if (generate != null && Boolean.parseBoolean(generate) && this.hasRestMetadata(vdb) && this.deployed.compareAndSet(false, true)) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RestASMBasedWebArchiveBuilder builder = new RestASMBasedWebArchiveBuilder();
                            byte[] warContents = builder.createRestArchive(vdb);
                            if (!vdb.getStatus().equals((Object)VDB.Status.ACTIVE)) {
                                return;
                            }
                            ResteasyEnabler.this.admin.deploy(warName, (InputStream)new ByteArrayInputStream(warContents), false);
                        }
                        catch (FileNotFoundException e) {
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RestServicePlugin.Util.gs((BundleUtil.Event)RestServicePlugin.Event.TEIID28004, new Object[]{warName}));
                        }
                        catch (IOException e) {
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RestServicePlugin.Util.gs((BundleUtil.Event)RestServicePlugin.Event.TEIID28004, new Object[]{warName}));
                        }
                        catch (AdminException e) {
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RestServicePlugin.Util.gs((BundleUtil.Event)RestServicePlugin.Event.TEIID28004, new Object[]{warName}));
                        }
                    }
                };
                this.executor.execute(job);
            }
        }
    }

    public synchronized void removed(String name, CompositeVDB cvdb) {
    }

    private String buildName(String name, String version) {
        return name + "_" + version + ".war";
    }

    private boolean hasRestMetadata(VDBMetaData vdb) {
        String securityType = vdb.getPropertyValue("{http://teiid.org/rest}security-type");
        if (securityType != null && !securityType.equalsIgnoreCase("none") && !securityType.equalsIgnoreCase("httpbasic")) {
            return false;
        }
        CompositeMetadataStore metadataStore = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            Schema schema = metadataStore.getSchema(model.getName());
            if (schema == null) continue;
            Collection procedures = schema.getProcedures().values();
            for (Procedure procedure : procedures) {
                String uri = procedure.getProperty("{http://teiid.org/rest}URI", false);
                String method = procedure.getProperty("{http://teiid.org/rest}METHOD", false);
                if (uri == null || method == null) continue;
                return true;
            }
        }
        return false;
    }
}

