/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Base64;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.StringUtil;
import org.teiid.jboss.rest.RestServicePlugin;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public abstract class TeiidRSProvider {
    public StreamingOutput execute(final String vdbName, final String version, final String procedureName, final LinkedHashMap<String, String> parameters, final String charSet, final boolean passthroughAuth, final boolean usingReturn) throws SQLException {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                Connection conn = null;
                try {
                    conn = TeiidRSProvider.this.getConnection(vdbName, version, passthroughAuth);
                    LinkedHashMap updatedParameters = TeiidRSProvider.this.convertParameters(conn, vdbName, procedureName, parameters);
                    InputStream is = TeiidRSProvider.this.executeProc(conn, procedureName, updatedParameters, charSet, usingReturn);
                    ObjectConverterUtil.write((OutputStream)output, (InputStream)is, (int)-1);
                }
                catch (SQLException e) {
                    throw new WebApplicationException((Throwable)e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        };
    }

    public StreamingOutput executePost(final String vdbName, final String version, final String procedureName, final MultipartFormDataInput parameters, final String charSet, final boolean passthroughAuth, final boolean usingReturn) throws SQLException {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                Connection conn = null;
                try {
                    conn = TeiidRSProvider.this.getConnection(vdbName, version, passthroughAuth);
                    LinkedHashMap updatedParameters = TeiidRSProvider.this.convertParameters(conn, vdbName, procedureName, parameters);
                    InputStream is = TeiidRSProvider.this.executeProc(conn, procedureName, updatedParameters, charSet, usingReturn);
                    ObjectConverterUtil.write((OutputStream)output, (InputStream)is, (int)-1);
                }
                catch (SQLException e) {
                    throw new WebApplicationException((Throwable)e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream executeProc(Connection conn, String procedureName, LinkedHashMap<String, Object> parameters, String charSet, boolean usingReturn) throws SQLException {
        boolean hasResultSet;
        if (charSet != null && charSet.trim().isEmpty()) {
            charSet = null;
        }
        Object result = null;
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        if (usingReturn) {
            sb.append("? = ");
        }
        sb.append("CALL ").append(procedureName);
        sb.append("(");
        boolean first = true;
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(SQLStringVisitor.escapeSinglePart((String)entry.getKey())).append("=>?");
        }
        sb.append(") }");
        CallableStatement statement = conn.prepareCall(sb.toString());
        if (!parameters.isEmpty()) {
            int i = usingReturn ? 2 : 1;
            for (Object value : parameters.values()) {
                if (value == null) continue;
                statement.setObject(i++, value);
            }
        }
        if (hasResultSet = statement.execute()) {
            ResultSet rs = statement.getResultSet();
            if (!rs.next()) throw new SQLException(RestServicePlugin.Util.gs((BundleUtil.Event)RestServicePlugin.Event.TEIID28002, new Object[0]));
            result = rs.getObject(1);
            return this.handleResult(charSet, result);
        } else {
            if (!usingReturn) {
                throw new SQLException(RestServicePlugin.Util.gs((BundleUtil.Event)RestServicePlugin.Event.TEIID28002, new Object[0]));
            }
            result = statement.getObject(1);
        }
        return this.handleResult(charSet, result);
    }

    private LinkedHashMap<String, Object> convertParameters(Connection conn, String vdbName, String procedureName, LinkedHashMap<String, String> inputParameters) throws SQLException {
        LinkedHashMap<String, Class<?>> expectedTypes = this.getParameterTypes(conn, vdbName, procedureName);
        LinkedHashMap<String, Object> expectedValues = new LinkedHashMap<String, Object>();
        try {
            for (String columnName : inputParameters.keySet()) {
                Class runtimeType = (Class)expectedTypes.get(columnName);
                if (runtimeType == null) {
                    throw new SQLException(RestServicePlugin.Util.gs((BundleUtil.Event)RestServicePlugin.Event.TEIID28001, new Object[]{columnName, procedureName}));
                }
                Object value = inputParameters.get(columnName);
                if (value != null) {
                    if (Array.class.isAssignableFrom(runtimeType)) {
                        List array = StringUtil.split((String)value, (String)",");
                        value = array.toArray(new String[array.size()]);
                    } else if (DataTypeManager.DefaultDataClasses.VARBINARY.isAssignableFrom(runtimeType)) {
                        value = Base64.decode((CharSequence)value);
                    } else if (DataTypeManager.isTransformable(String.class, (Class)runtimeType)) {
                        Transform t = DataTypeManager.getTransform(String.class, (Class)runtimeType);
                        value = t.transform(value, runtimeType);
                    }
                }
                expectedValues.put(columnName, value);
            }
            return expectedValues;
        }
        catch (TransformationException e) {
            throw new SQLException(e);
        }
    }

    private LinkedHashMap<String, Object> convertParameters(Connection conn, String vdbName, String procedureName, MultipartFormDataInput form) throws SQLException {
        LinkedHashMap<String, Class<?>> runtimeTypes = this.getParameterTypes(conn, vdbName, procedureName);
        LinkedHashMap<String, Object> expectedValues = new LinkedHashMap<String, Object>();
        Map inputParameters = form.getFormDataMap();
        for (String columnName : inputParameters.keySet()) {
            Class runtimeType = (Class)runtimeTypes.get(columnName);
            if (runtimeType == null) {
                throw new SQLException(RestServicePlugin.Util.gs((BundleUtil.Event)RestServicePlugin.Event.TEIID28001, new Object[]{columnName, procedureName}));
            }
            if (runtimeType.isAssignableFrom(Array.class)) {
                List valueStreams = (List)inputParameters.get(columnName);
                ArrayList<String> array = new ArrayList<String>();
                try {
                    for (InputPart part : valueStreams) {
                        array.add(part.getBodyAsString());
                    }
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                expectedValues.put(columnName, array.toArray(new Object[array.size()]));
                continue;
            }
            InputPart part = (InputPart)((List)inputParameters.get(columnName)).get(0);
            try {
                expectedValues.put(columnName, this.convertToRuntimeType(runtimeType, part));
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        return expectedValues;
    }

    private Object convertToRuntimeType(Class<?> runtimeType, final InputPart part) throws IOException, SQLException {
        if (SQLXML.class.isAssignableFrom(runtimeType)) {
            SQLXMLImpl xml = new SQLXMLImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return (InputStream)part.getBody(InputStream.class, null);
                }
            });
            if (this.charset(part) != null) {
                xml.setEncoding(this.charset(part));
            }
            return xml;
        }
        if (Blob.class.isAssignableFrom(runtimeType)) {
            return new BlobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return (InputStream)part.getBody(InputStream.class, null);
                }
            });
        }
        if (Clob.class.isAssignableFrom(runtimeType)) {
            ClobImpl clob = new ClobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return (InputStream)part.getBody(InputStream.class, null);
                }
            }, -1L);
            if (this.charset(part) != null) {
                clob.setEncoding(this.charset(part));
            }
            return clob;
        }
        if (DataTypeManager.DefaultDataClasses.VARBINARY.isAssignableFrom(runtimeType)) {
            return Base64.decode((CharSequence)part.getBodyAsString());
        }
        if (DataTypeManager.isTransformable(String.class, runtimeType)) {
            try {
                return DataTypeManager.transformValue((Object)part.getBodyAsString(), runtimeType);
            }
            catch (TransformationException e) {
                throw new SQLException(e);
            }
        }
        return part.getBodyAsString();
    }

    private String charset(InputPart part) {
        return (String)part.getMediaType().getParameters().get("charset");
    }

    private LinkedHashMap<String, Class<?>> getParameterTypes(Connection conn, String vdbName, String procedureName) throws SQLException {
        String schemaName = procedureName.substring(0, procedureName.lastIndexOf(46)).replace('\"', ' ').trim();
        String procName = procedureName.substring(procedureName.lastIndexOf(46) + 1).replace('\"', ' ').trim();
        LinkedHashMap expectedTypes = new LinkedHashMap();
        try {
            ResultSet rs = conn.getMetaData().getProcedureColumns(vdbName, schemaName, procName, "%");
            while (rs.next()) {
                String columnName = rs.getString(4);
                int columnDataType = rs.getInt(6);
                Class runtimeType = DataTypeManager.getRuntimeType(Class.forName(JDBCSQLTypeInfo.getJavaClassName((int)columnDataType)));
                expectedTypes.put(columnName, runtimeType);
            }
            rs.close();
            return expectedTypes;
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
    }

    private InputStream handleResult(String charSet, Object result) throws SQLException {
        if (result == null) {
            return null;
        }
        if (result instanceof SQLXML) {
            if (charSet != null) {
                XMLSerialize serialize = new XMLSerialize();
                serialize.setTypeString("blob");
                serialize.setDeclaration(Boolean.valueOf(true));
                serialize.setEncoding(charSet);
                serialize.setDocument(Boolean.valueOf(true));
                try {
                    return ((BlobType)XMLSystemFunctions.serialize((XMLSerialize)serialize, (XMLType)new XMLType((SQLXML)result))).getBinaryStream();
                }
                catch (TransformationException e) {
                    throw new SQLException(e);
                }
            }
            return ((SQLXML)result).getBinaryStream();
        }
        if (result instanceof Blob) {
            return ((Blob)result).getBinaryStream();
        }
        if (result instanceof Clob) {
            return new ReaderInputStream(((Clob)result).getCharacterStream(), charSet == null ? Charset.defaultCharset() : Charset.forName(charSet));
        }
        return new ByteArrayInputStream(result.toString().getBytes(charSet == null ? Charset.defaultCharset() : Charset.forName(charSet)));
    }

    public StreamingOutput executeQuery(final String vdbName, final String vdbVersion, final String sql, boolean json, final boolean passthroughAuth) throws SQLException {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                Connection conn = null;
                try {
                    conn = TeiidRSProvider.this.getConnection(vdbName, vdbVersion, passthroughAuth);
                    Statement statement = conn.createStatement();
                    boolean hasResultSet = statement.execute(sql);
                    Object result = null;
                    if (hasResultSet) {
                        ResultSet rs = statement.getResultSet();
                        if (rs.next()) {
                            result = rs.getObject(1);
                        } else {
                            throw new SQLException(RestServicePlugin.Util.gs((BundleUtil.Event)RestServicePlugin.Event.TEIID28002, new Object[0]));
                        }
                    }
                    InputStream is = TeiidRSProvider.this.handleResult(Charset.defaultCharset().name(), result);
                    ObjectConverterUtil.write((OutputStream)output, (InputStream)is, (int)-1);
                }
                catch (SQLException e) {
                    throw new WebApplicationException((Throwable)e);
                }
                finally {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        };
    }

    private Connection getConnection(String vdbName, String version, boolean passthough) throws SQLException {
        TeiidDriver driver = new TeiidDriver();
        return driver.connect("jdbc:teiid:" + vdbName + "." + version + ";" + (passthough ? "PassthroughAuthentication=true;" : ""), null);
    }
}

