/*
 * Copyright Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags and
 * the COPYRIGHT.txt file distributed with this work.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.teiid.adminshell;

import java.util.List;

import org.codehaus.groovy.tools.shell.CommandSupport;
import org.codehaus.groovy.tools.shell.Groovysh;

public class SqlHelpCommand extends CommandSupport {

	protected SqlHelpCommand(Groovysh shell) {
		super(shell, "sqlhelp", "\\sh");  //$NON-NLS-1$ //$NON-NLS-2$
	}

	@Override
	public Object execute(List args) {
		if (args.size() > 1) {
            fail(messages.format("error.unexpected_args", new Object[] {args.toString()}));  //$NON-NLS-1$
        }
		if (args.isEmpty()) {
			GroovySqlExtensions.sqlHelp();
		} else {
			GroovySqlExtensions.sqlHelp(args.get(0).toString());
		}
		return null;
	}

}
