/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.script.junit;

import bsh.BshMethod;
import bsh.Interpreter;
import bsh.TargetError;
import com.metamatrix.script.junit.BshTestSuite;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;

public class BshTestCase
extends TestCase {
    String script = null;
    BshMethod method = null;
    Interpreter interpreter = null;
    String scriptFileName = null;

    public BshTestCase(String scriptName, BshMethod method, Interpreter interpreter) {
        super(method.getName());
        this.scriptFileName = scriptName;
        this.method = method;
        this.interpreter = interpreter;
    }

    public static Test suite() {
        BshTestSuite suite = new BshTestSuite();
        return suite;
    }

    protected void runTest() throws Throwable {
        BshMethod setup = this.interpreter.getNameSpace().getMethod("setUp", new Class[0]);
        if (setup != null) {
            setup.invoke(null, this.interpreter);
        }
        try {
            System.out.println("Running test=" + this.method.getName());
            this.method.invoke(null, this.interpreter);
        }
        catch (TargetError e) {
            this.printStackTrace(e, System.err);
            throw this.removeVeboseStackTrace(e.getTarget());
        }
        finally {
            BshMethod teardown = this.interpreter.getNameSpace().getMethod("tearDown", new Class[0]);
            if (teardown != null) {
                teardown.invoke(null, this.interpreter);
            }
        }
    }

    void printStackTrace(TargetError te, PrintStream out) {
        Throwable t = te.getTarget();
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String line = null;
        BufferedReader r = new BufferedReader(new StringReader(sw.toString()));
        try {
            while ((line = r.readLine()) != null) {
                if (line.startsWith("\tat bsh.") || line.startsWith("\tat sun.reflect.") || line.startsWith("\tat junit.") || line.startsWith("\tat org.eclipse.jdt")) continue;
                out.println(line);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        out.println("\n\tbsh.callstack");
        out.println("\t" + te.getErrorText() + " at Line: " + te.getErrorLineNumber() + " : in file: " + te.getErrorSourceFile());
        out.println(te.getScriptStackTrace());
        out.println("\twhile running \"" + this.method.getName() + "()\" method in script file \"" + this.scriptFileName + "\"");
    }

    Throwable removeVeboseStackTrace(Throwable t) {
        if (t.getCause() != null) {
            return new Exception(t.getMessage(), this.removeVeboseStackTrace(t.getCause()));
        }
        StackTraceElement[] traces = t.getStackTrace();
        ArrayList<StackTraceElement> newtrace = new ArrayList<StackTraceElement>();
        for (int i = 0; i < traces.length; ++i) {
            StackTraceElement trace = traces[i];
            String clsName = trace.getClassName();
            if (clsName.startsWith("bsh.") || clsName.startsWith("sun.reflect.") || clsName.startsWith("junit.") || clsName.startsWith("org.eclipse.jdt")) continue;
            newtrace.add(trace);
        }
        Exception e = new Exception(t.getMessage());
        e.setStackTrace(newtrace.toArray(new StackTraceElement[newtrace.size()]));
        return e;
    }
}

