/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.script.junit;

import bsh.BshMethod;
import bsh.Interpreter;
import com.metamatrix.script.junit.BshTestCase;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BshTestSuite
extends TestSuite {
    public BshTestSuite() {
    }

    public BshTestSuite(String name) {
        super(name);
    }

    public void addTest(String bshScript) {
        try {
            BshTestSuite thisScriptSuite = new BshTestSuite(bshScript);
            Interpreter interpreter = new Interpreter();
            interpreter.eval("importCommands(\"commands\")");
            this.evaluate(interpreter, bshScript);
            String runOnly = (String)interpreter.get("runOnly");
            BshMethod[] methods = interpreter.getNameSpace().getMethods();
            methods = runOnly == null || runOnly.length() == 0 ? this.getMatchingTests("^test.*", methods) : this.getMatchingTests(runOnly, methods);
            for (int i = 0; i < methods.length; ++i) {
                thisScriptSuite.addTest((Test)new BshTestCase(bshScript, methods[i], interpreter));
            }
            super.addTest((Test)thisScriptSuite);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to add tests from bean shell script " + bshScript, e);
        }
    }

    public void addTest(String bshScript, String methodNamePattern) {
        try {
            Interpreter interpreter = new Interpreter();
            this.evaluate(interpreter, bshScript);
            BshMethod[] methods = interpreter.getNameSpace().getMethods();
            methods = this.getMatchingTests(methodNamePattern, methods);
            for (int i = 0; i < methods.length; ++i) {
                super.addTest((Test)new BshTestCase(bshScript, methods[i], interpreter));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to add tests from bean shell script " + bshScript, e);
        }
    }

    private void evaluate(Interpreter interpreter, String bshScript) throws Exception {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        URL url = loader.getResource(bshScript);
        if (url == null) {
            interpreter.source(bshScript);
        } else {
            String filename = url.getFile();
            InputStream is = loader.getResourceAsStream(bshScript);
            InputStreamReader isr = new InputStreamReader(is);
            interpreter.eval((Reader)isr, interpreter.getNameSpace(), filename);
            isr.close();
            is.close();
        }
    }

    BshMethod[] getMatchingTests(String pattern, BshMethod[] methods) {
        ArrayList<BshMethod> matchedMethods = new ArrayList<BshMethod>();
        for (int i = 0; i < methods.length; ++i) {
            String[] parameters = methods[i].getParameterNames();
            if (!methods[i].getName().matches(pattern) || parameters.length != 0) continue;
            matchedMethods.add(methods[i]);
        }
        return matchedMethods.toArray(new BshMethod[matchedMethods.size()]);
    }
}

