/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.script.shell;

import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.util.Util;
import com.metamatrix.script.shell.FilePrintStream;
import com.metamatrix.script.shell.ReaderInterceptor;
import com.metamatrix.script.shell.SimpleParser;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;

public class MMAdmin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        boolean gui = Boolean.getBoolean("gui");
        System.setProperty("metamatrix.config.none", "true");
        if (args.length == 0) {
            if (!Capabilities.classExists((String)"bsh.util.Util")) {
                System.out.println("Can't find the BeanShell utilities...");
            }
            FileWriter logger = new FileWriter("adminscript.txt", true);
            FilePrintStream out = new FilePrintStream(System.out, "mmadmin.log");
            try {
                SimpleParser p = new SimpleParser();
                Interpreter interpreter = new Interpreter((Reader)new ReaderInterceptor(p, logger), (PrintStream)out, (PrintStream)out, true);
                interpreter.eval("importCommands(\"commands\")");
                interpreter.eval("load(\"server\")");
                p.setInterpreter(interpreter);
                if (Capabilities.haveSwing() && gui) {
                    Util.startSplashScreen();
                    interpreter.eval("desktop()");
                }
                interpreter.run();
            }
            catch (EvalError e) {
                System.err.println("Couldn't start desktop: " + (Object)((Object)e));
            }
            finally {
                logger.close();
                ((PrintStream)out).close();
            }
        } else {
            Interpreter.main((String[])args);
        }
    }
}

