/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.script.shell;

import bsh.Interpreter;
import com.metamatrix.script.shell.CustomParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;

public class ReaderInterceptor
extends Reader {
    private BufferedReader in = null;
    private CustomParser parser = null;
    private Writer logger;
    private String currentStr = null;
    private int currentIndex = 0;

    public ReaderInterceptor(CustomParser parser, Writer logger) {
        this(new InputStreamReader(System.in), parser, logger);
    }

    public ReaderInterceptor(Reader in, CustomParser parser, Writer logger) {
        this.parser = parser;
        this.in = new BufferedReader(in);
        this.logger = logger;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int lengthToCopy;
        int newLine = 0;
        block0: while (this.currentStr == null) {
            StringBuffer sb = new StringBuffer();
            String line = this.in.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    newLine = 0;
                    sb.append(line);
                } else if (++newLine > 0) {
                    sb.append(";");
                    line = ";";
                }
                if (line.endsWith(";")) {
                    this.currentStr = this.parser.convert(sb.toString().trim());
                    if (this.logger != null && !this.currentStr.equals(";")) {
                        this.logger.write(this.currentStr);
                        this.logger.write(System.getProperty("line.separator"));
                        this.logger.flush();
                    }
                    this.currentIndex = 0;
                    continue block0;
                }
                if (line.length() > 0) {
                    sb.append(" ");
                }
                line = this.in.readLine();
            }
        }
        int n = lengthToCopy = this.currentStr.length() - this.currentIndex < len ? this.currentStr.length() - this.currentIndex : len;
        if (lengthToCopy == 0) {
            this.currentStr = System.getProperty("line.separator") + System.getProperty("line.separator");
            lengthToCopy = this.currentStr.length() - this.currentIndex < len ? this.currentStr.length() - this.currentIndex : len;
        }
        System.arraycopy(this.currentStr.toCharArray(), this.currentIndex, cbuf, off, lengthToCopy);
        this.currentIndex += lengthToCopy;
        if (this.currentIndex == this.currentStr.length()) {
            this.currentStr = null;
        }
        return lengthToCopy;
    }

    public static void main(String[] args) {
        final String ls = System.getProperty("line.separator");
        CustomParser p = new CustomParser(){

            @Override
            public String convert(String str) {
                System.out.println(str);
                if (str.matches("select .+|insert into.+|delete .+|update table .*|exec .+")) {
                    return "execute(\"" + str.substring(0, str.length() - 1) + "\");" + ls;
                }
                return "foo:" + str + ls;
            }

            @Override
            public void setInterpreter(Interpreter i) {
            }
        };
        BufferedReader i = new BufferedReader(new ReaderInterceptor(p, null));
        try {
            String line = i.readLine();
            while (line != null) {
                System.out.println(line);
                line = i.readLine();
            }
        }
        catch (IOException err) {
            err.printStackTrace();
        }
    }
}

