/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminshell;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.adminapi.CacheStatistics;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.WorkerPoolStatistics;
import org.teiid.adminshell.Help;

public class AdminShell {
    protected static Logger log = Logger.getLogger(AdminShell.class.getName());
    static Properties p;
    private static int connectionCount;
    static Admin internalAdmin;
    private static String currentName;
    private static HashMap<String, Admin> connections;
    private static Help help;

    @Help.Doc(text="Get a named Admin connection to the specified server")
    public static void connectAsAdmin(@Help.Doc(text="host - hostname") String host, @Help.Doc(text="port - port") int port, @Help.Doc(text="username") String username, @Help.Doc(text="password") String password, @Help.Doc(text="connection name") String connectionName) throws AdminException {
        internalAdmin = AdminFactory.getInstance().createAdmin(host, port, username, password.toCharArray());
        currentName = connectionName;
        Admin old = connections.put(connectionName, internalAdmin);
        if (old != null) {
            System.out.println("Closing previous admin associated with " + connectionName);
            old.close();
        }
    }

    @Help.Doc(text="Connect as Admin using the defaults from connection.properties")
    public static void connectAsAdmin() throws AdminException {
        AdminShell.loadConnectionProperties();
        AdminShell.connectAsAdmin(p.getProperty("admin.host", "localhost"), Integer.parseInt(p.getProperty("admin.port", "9999")), p.getProperty("admin.user", "admin"), p.getProperty("admin.password", "admin"), "conn-" + connectionCount++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadConnectionProperties() {
        if (p != null) {
            return;
        }
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("connection.properties");
            props.load(fis);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not load default connection properties.", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        p = props;
    }

    @Help.Doc(text="Adds a mapped role to the specified data role")
    public static void addDataRoleMapping(@Help.Doc(text="vdb name") String vdbName, @Help.Doc(text="vdb version") int vdbVersion, @Help.Doc(text="dataRole name") String policyName, @Help.Doc(text="mapped role name") String role) throws AdminException {
        AdminShell.getAdmin().addDataRoleMapping(vdbName, vdbVersion, policyName, role);
    }

    @Help.Doc(text="Assign a translator and data source to a source Model")
    public static void assignToModel(@Help.Doc(text="vdb name") String vdbName, @Help.Doc(text="vdb version") int vdbVersion, @Help.Doc(text="model name") String modelName, @Help.Doc(text="source name") String sourceName, @Help.Doc(text="translator name") String translatorName, @Help.Doc(text="jndi name") String jndiName) throws AdminException {
        AdminShell.getAdmin().assignToModel(vdbName, vdbVersion, modelName, sourceName, translatorName, jndiName);
    }

    @Help.Doc(text="Cancel a request")
    public static void cancelRequest(@Help.Doc(text="session id") String sessionId, @Help.Doc(text="execution id") long executionId) throws AdminException {
        AdminShell.getAdmin().cancelRequest(sessionId, executionId);
    }

    @Help.Doc(text="Clear the given cache")
    public static void clearCache(@Help.Doc(text="cache type") String cacheType) throws AdminException {
        AdminShell.getAdmin().clearCache(cacheType);
    }

    @Help.Doc(text="Clear the given cache for a VDB")
    public static void clearCache(@Help.Doc(text="cache type") String cacheType, @Help.Doc(text="vdb name") String vdbName, @Help.Doc(text="vdb version") int vdbVersion) throws AdminException {
        AdminShell.getAdmin().clearCache(cacheType, vdbName, vdbVersion);
    }

    @Help.Doc(text="Undeploy a artifact (JAR, RAR, VDB)")
    public static void undeploy(@Help.Doc(text="deployed name") String deployedName) throws AdminException {
        AdminShell.getAdmin().undeploy(deployedName);
    }

    @Help.Doc(text="Get all cache type Strings")
    public static Collection<String> getCacheTypes() throws AdminException {
        return AdminShell.getAdmin().getCacheTypes();
    }

    @Help.Doc(text="Change a VDB Connection Type")
    public static void changeVDBConnectionType(@Help.Doc(text="vdb name") String vdbName, @Help.Doc(text="vdb version") int vdbVersion, @Help.Doc(text="Connection Type (NONE, BY_VERSION, or ANY") String type) throws AdminException {
        AdminShell.getAdmin().changeVDBConnectionType(vdbName, vdbVersion, VDB.ConnectionType.valueOf((String)type));
    }

    @Help.Doc(text="Get all translator instances")
    public static Collection<? extends Translator> getTranslators() throws AdminException {
        return AdminShell.getAdmin().getTranslators();
    }

    @Help.Doc(text="Get the specified ConnectionFactory")
    public static Translator getTranslator(@Help.Doc(text="deployed name") String deployedName) throws AdminException {
        return AdminShell.getAdmin().getTranslator(deployedName);
    }

    @Help.Doc(text="Get all PropertyDefinitions for the given template")
    public static Collection<? extends PropertyDefinition> getTemplatePropertyDefinitions(@Help.Doc(text="template name") String templateName) throws AdminException {
        return AdminShell.getAdmin().getTemplatePropertyDefinitions(templateName);
    }

    @Help.Doc(text="Get all Request instances")
    public static Collection<? extends Request> getRequests() throws AdminException {
        return AdminShell.getAdmin().getRequests();
    }

    @Help.Doc(text="Get all Request instances for the given session")
    public static Collection<? extends Request> getRequestsForSession(@Help.Doc(text="session id") String sessionId) throws AdminException {
        return AdminShell.getAdmin().getRequestsForSession(sessionId);
    }

    @Help.Doc(text="Get all Session instances")
    public static Collection<? extends Session> getSessions() throws AdminException {
        return AdminShell.getAdmin().getSessions();
    }

    @Help.Doc(text="Get all Transaction instances")
    public static Collection<? extends Transaction> getTransactions() throws AdminException {
        return AdminShell.getAdmin().getTransactions();
    }

    @Help.Doc(text="Get a specific VDB")
    public static VDB getVDB(@Help.Doc(text="vdb name") String vdbName, @Help.Doc(text="vdb version") int vbdVersion) throws AdminException {
        return AdminShell.getAdmin().getVDB(vdbName, vbdVersion);
    }

    @Help.Doc(text="Get all VDB instances")
    public static Collection<? extends VDB> getVDBs() throws AdminException {
        return AdminShell.getAdmin().getVDBs();
    }

    @Help.Doc(text="Get thread pool statistics for Teiid")
    public static Collection<? extends WorkerPoolStatistics> getWorkerPoolStats() throws AdminException {
        return AdminShell.getAdmin().getWorkerPoolStats();
    }

    @Help.Doc(text="Get cache statistics for given cache type")
    public static Collection<? extends CacheStatistics> getCacheStats(@Help.Doc(text="cacheType") String identifier) throws AdminException {
        return AdminShell.getAdmin().getCacheStats(identifier);
    }

    @Help.Doc(text="Remove a mapped role for the data role")
    public static void removeDataRoleMapping(@Help.Doc(text="vdb name") String vdbName, @Help.Doc(text="vdb version") int vdbVersion, @Help.Doc(text="dataRole name") String policyName, @Help.Doc(text="mapped role name") String role) throws AdminException {
        AdminShell.getAdmin().removeDataRoleMapping(vdbName, vdbVersion, policyName, role);
    }

    @Help.Doc(text="Set the any authenticated flag for the data role")
    public static void setAnyAuthenticatedForDataRole(@Help.Doc(text="vdb name") String vdbName, @Help.Doc(text="vdb version") int vdbVersion, @Help.Doc(text="dataRole name") String dataRole, @Help.Doc(text="any authenticated") boolean anyAuthenticated) throws AdminException {
        AdminShell.getAdmin().setAnyAuthenticatedForDataRole(vdbName, vdbVersion, dataRole, anyAuthenticated);
    }

    @Help.Doc(text="Terminate a session and associated requests")
    public static void terminateSession(@Help.Doc(text="session id") String sessionId) throws AdminException {
        AdminShell.getAdmin().terminateSession(sessionId);
    }

    @Help.Doc(text="Terminate a transaction")
    public static void terminateTransaction(@Help.Doc(text="transaction id") String transactionId) throws AdminException {
        AdminShell.getAdmin().terminateTransaction(transactionId);
    }

    @Help.Doc(text="Checks if a translator exists")
    public static boolean hasTranslator(@Help.Doc(text="deployed name") String factoryName) throws AdminException {
        Collection bindings = AdminShell.getAdmin().getTranslators();
        for (Translator binding : bindings) {
            if (!binding.getName().equals(factoryName)) continue;
            return true;
        }
        return false;
    }

    @Help.Doc(text="Checks if a VDB exists")
    public static boolean hasVDB(@Help.Doc(text="vdb name") String vdbName) throws AdminException {
        Collection vdbs = AdminShell.getAdmin().getVDBs();
        for (VDB vdb : vdbs) {
            if (!vdb.getName().equals(vdbName)) continue;
            return true;
        }
        return false;
    }

    @Help.Doc(text="Checks if a specific VDB version exists")
    public static boolean hasVDB(@Help.Doc(text="vdb name") String vdbName, @Help.Doc(text="vdb version") int version) throws AdminException {
        Collection vdbs = AdminShell.getAdmin().getVDBs();
        for (VDB vdb : vdbs) {
            if (!vdb.getName().equals(vdbName) || vdb.getVersion() != version) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Help.Doc(text="Deploy a Artifact (JAR, RAR, VDB) from file")
    public static void deploy(@Help.Doc(text="file name") String vdbFile) throws AdminException, FileNotFoundException {
        File file = new File(vdbFile);
        FileInputStream fis = new FileInputStream(file);
        try {
            AdminShell.getAdmin().deploy(file.getName(), (InputStream)fis);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Help.Doc(text="Create a data source from supplied properties")
    public static void createDataSource(@Help.Doc(text="deployed name") String deploymentName, @Help.Doc(text="template name") String templateName, @Help.Doc(text="properties") Properties properties) throws AdminException {
        AdminShell.getAdmin().createDataSource(deploymentName, templateName, properties);
    }

    @Help.Doc(text="Delete data source")
    public static void deleteDataSource(@Help.Doc(text="deployed name") String deployedName) throws AdminException {
        AdminShell.getAdmin().deleteDataSource(deployedName);
    }

    @Help.Doc(text="Available data sources")
    public static Collection<String> getDataSourceNames() throws AdminException {
        return AdminShell.getAdmin().getDataSourceNames();
    }

    @Help.Doc(text="Available data source template names")
    public static Set<String> getDataSourceTemplateNames() throws AdminException {
        return AdminShell.getAdmin().getDataSourceTemplateNames();
    }

    @Help.Doc(text="Get the current org.teiid.adminapi.Admin instance for direct use. Note: Used for advanced usecases to bypass AdminShell methods")
    public static Admin getAdmin() {
        if (internalAdmin == null) {
            throw new NullPointerException("Not connected.  You must call a \"connectAsAdmin\" method or choose an active connection via \"useConnection\".");
        }
        return internalAdmin;
    }

    @Help.Doc(text="Disconnect the current connection for the server")
    public static void disconnect() {
        if (internalAdmin != null) {
            internalAdmin.close();
            internalAdmin = null;
            connections.remove(currentName);
            currentName = null;
        }
    }

    @Help.Doc(text="Disconnect all connections from the server")
    public static void disconnectAll() {
        for (Admin admin : connections.values()) {
            admin.close();
        }
        connections.clear();
        internalAdmin = null;
        currentName = null;
    }

    @Help.Doc(text="Use another connection")
    public static void useConnection(@Help.Doc(text="connection name") String name) {
        Admin admin = connections.get(name);
        if (admin == null) {
            System.out.println("Warning: connection is not active for " + name);
            return;
        }
        internalAdmin = admin;
        currentName = name;
    }

    @Help.Doc(text="Returns the current connection name")
    public static String getConnectionName() {
        return currentName;
    }

    @Help.Doc(text="Return all connection names")
    public static Collection<String> getAllConnections() {
        return connections.keySet();
    }

    @Help.Doc(text="Show help for all admin methods")
    public static void adminHelp() {
        help.help();
    }

    @Help.Doc(text="Show help for the given admin method")
    public static void adminHelp(@Help.Doc(text="method name") String method) {
        help.help(method);
    }

    static {
        connectionCount = 1;
        connections = new HashMap();
        help = new Help(AdminShell.class);
    }
}

