/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.Closure;
import groovy.sql.GroovyResultSet;
import groovy.sql.GroovyResultSetProxy;
import groovy.sql.Sql;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;
import java.util.logging.Level;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.jdbc.TeiidStatement;

public final class TeiidSql
extends Sql {
    private int maxRows;
    private PlanNode plan;
    private Collection<Annotation> annotations;
    private String debugLog;
    private SQLWarning warnings;

    public TeiidSql(Connection connection) {
        super(connection);
    }

    protected void configure(Statement statement) {
        super.configure(statement);
        try {
            statement.setMaxRows(this.maxRows);
        }
        catch (SQLException e) {
            LOG.log(Level.WARNING, "Caught exception setting max rows: " + e, e);
        }
        this.plan = null;
        this.annotations = null;
        this.debugLog = null;
        this.warnings = null;
    }

    public void eachRow(String sql, Closure metaClosure, Closure rowClosure) throws SQLException {
        Sql.AbstractQueryCommand command = this.createQueryCommand(sql);
        ResultSet results = null;
        try {
            results = command.execute();
            if (metaClosure != null) {
                metaClosure.call((Object)results.getMetaData());
            }
            GroovyResultSet groovyRS = new GroovyResultSetProxy(results).getImpl();
            while (groovyRS.next()) {
                rowClosure.call((Object)groovyRS);
            }
        }
        catch (SQLException e) {
            LOG.warning("Failed to execute: " + sql + " because: " + e.getMessage());
            throw e;
        }
        finally {
            command.closeResources();
        }
    }

    protected void closeResources(Connection connection, Statement statement) {
        this.getPlanInfo(statement);
        super.closeResources(connection, statement);
    }

    protected void closeResources(Connection connection, Statement statement, ResultSet results) {
        this.getPlanInfo(statement);
        super.closeResources(connection, statement, results);
    }

    protected void getPlanInfo(Statement s) {
        TeiidStatement ts;
        if (s == null) {
            return;
        }
        try {
            ts = s.unwrap(TeiidStatement.class);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.plan = ts.getPlanDescription();
        this.annotations = ts.getAnnotations();
        this.debugLog = ts.getDebugLog();
        try {
            this.warnings = ts.getWarnings();
        }
        catch (SQLException e) {
            LOG.log(Level.WARNING, "Caught exception getting warnings: " + e, e);
        }
    }

    public SQLWarning getSQLWarnings() {
        return this.warnings;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public PlanNode getPlan() {
        return this.plan;
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String getDebugLog() {
        return this.debugLog;
    }
}

