/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminshell;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class Help {
    private TreeMap<String, List<String>> help = new TreeMap();
    private List<String> shortHelp = new ArrayList<String>();

    public Help(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            StringBuilder sb = new StringBuilder();
            Doc doc = method.getAnnotation(Doc.class);
            StringBuilder shortSb = new StringBuilder();
            shortSb.append(method.getName()).append("(");
            if (method.getParameterTypes().length > 0) {
                shortSb.append(method.getParameterTypes().length);
            }
            shortSb.append(")");
            String shortHelpStr = String.format("  %-25s", shortSb.toString());
            if (doc != null) {
                sb.append("/*\n  ").append(doc.text());
                for (String string : doc.moreText()) {
                    sb.append("\n  ").append(string);
                }
                sb.append("\n */\n");
                shortHelpStr = shortHelpStr + " -- " + doc.text();
            }
            this.shortHelp.add(shortHelpStr);
            Class<?> returnType = method.getReturnType();
            sb.append(returnType.getSimpleName()).append(" ");
            sb.append(method.getName()).append("(");
            Class<?>[] params = method.getParameterTypes();
            block2: for (int i = 0; i < params.length; ++i) {
                Annotation[] annos;
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("\n    ").append(params[i].getSimpleName());
                for (Annotation annotation : annos = method.getParameterAnnotations()[i]) {
                    Doc paramdoc;
                    if (!(annotation instanceof Doc) || (paramdoc = (Doc)annotation).text() == null) continue;
                    sb.append(" /* ").append(paramdoc.text()).append(" */");
                    continue block2;
                }
            }
            sb.append(")\n");
            for (Class<?> exceptionClass : method.getExceptionTypes()) {
                sb.append("  throws ").append(exceptionClass.getSimpleName()).append("\n");
            }
            String key = method.getName().toUpperCase();
            List<String> signatures = this.help.get(key);
            if (signatures == null) {
                signatures = new LinkedList<String>();
                this.help.put(key, signatures);
            }
            signatures.add(sb.toString());
        }
        Collections.sort(this.shortHelp);
    }

    public void help() {
        System.out.println("/* method(arg count)        -- description */");
        for (String helpString : this.shortHelp) {
            System.out.println(helpString);
        }
    }

    public void help(String method) {
        List<String> helpStrings = null;
        if (method != null) {
            helpStrings = this.help.get(method.toUpperCase());
        }
        if (helpStrings != null) {
            for (String helpString : helpStrings) {
                System.out.println(helpString);
            }
        } else {
            System.out.println("Unknown method");
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Doc {
        public String text();

        public String[] moreText() default {};
    }
}

