/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.client.ResultsFuture;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.TestMMResultSet;
import com.metamatrix.query.unittest.TimestampUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.mockito.internal.progress.VerificationMode;

public class TestAllResultsImpl
extends TestCase {
    private static final long REQUEST_ID = 0L;
    private static final int TYPE_FORWARD_ONLY = 1003;
    private static final int TYPE_SCROLL_SENSITIVE = 1005;
    private static final int TYPE_SCROLL_INSENSITIVE = 1004;
    private MMStatement statement;

    public TestAllResultsImpl(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.statement = TestMMResultSet.createMockStatement();
    }

    public void testHasNext1() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg1(), this.statement);
        while (rs.next()) {
        }
        boolean actual = rs.hasNext();
        boolean expected = false;
        TestAllResultsImpl.assertEquals((boolean)expected, (boolean)actual);
        rs.close();
    }

    public void testHasNext2() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg1(), this.statement);
        for (int i = 1; i < results.length; ++i) {
            rs.next();
        }
        boolean actual = rs.hasNext();
        boolean expected = true;
        TestAllResultsImpl.assertEquals((boolean)expected, (boolean)actual);
        rs.close();
    }

    public void testNext1() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg1(), this.statement);
        boolean actual = rs.next();
        boolean expected = true;
        TestAllResultsImpl.assertEquals((String)" Actual doesn't match with expected. ", (boolean)expected, (boolean)actual);
        rs.close();
    }

    public void testNext2() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg1(), this.statement);
        int i = 0;
        while (rs.next()) {
            List actual = rs.getCurrentRecord();
            List<Object> expected = results[i];
            TestAllResultsImpl.assertEquals(expected, (Object)actual);
            ++i;
        }
        rs.close();
    }

    public void testNext3() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg1(), this.statement);
        TestAllResultsImpl.assertEquals((Object)new Integer(0), (Object)new Integer(rs.getRow()));
        rs.close();
    }

    public void testNext4() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg1(), this.statement);
        for (int i = 0; i < results.length - 1; ++i) {
            rs.next();
            List actual = rs.getCurrentRecord();
            List<Object> expected = results[i];
            TestAllResultsImpl.assertEquals(expected, (Object)actual);
        }
        rs.close();
    }

    public void testNext5() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg1(), this.statement);
        while (rs.next()) {
        }
        boolean actual = rs.hasNext();
        boolean expected = false;
        TestAllResultsImpl.assertEquals((boolean)expected, (boolean)actual);
        rs.close();
    }

    public void testGetObject1() throws Exception {
        List[] results = this.exampleResults2();
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg2a(), this.statement);
        String actual = null;
        String expected = "a3";
        for (int i = 0; i < results.length - 2; ++i) {
            rs.next();
        }
        if (rs.next()) {
            actual = (String)rs.getObject(2);
        }
        TestAllResultsImpl.assertEquals((String)expected, actual);
        rs.close();
    }

    public void testGetObject2() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg2a(), this.statement);
        if (rs.next()) {
            try {
                rs.getObject(6);
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    // empty if block
                }
            }
        }
        rs.close();
    }

    public void testGetRow() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg2(), this.statement);
        int expected = 0;
        TestAllResultsImpl.assertEquals((int)expected, (int)rs.getRow());
        if (rs.next()) {
            expected = 1;
            TestAllResultsImpl.assertEquals((int)expected, (int)rs.getRow());
        }
        rs.close();
    }

    public void testPrevious() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg1(), this.statement);
        while (rs.next()) {
        }
        int i = results.length - 1;
        while (rs.previous()) {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(new Integer(i + 1));
            TestAllResultsImpl.assertEquals(expected, (Object)rs.getCurrentRecord());
            --i;
        }
        rs.close();
    }

    public void testGetCurrentRecord() throws Exception {
        List[] results = this.exampleResults2();
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg2(), this.statement);
        rs.next();
        List actual = rs.getCurrentRecord();
        TestAllResultsImpl.assertEquals((Object)results[0], (Object)actual);
        rs.close();
    }

    public void testGetMetaData() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg2a(), this.statement);
        ResultSetMetaData rmetadata = rs.getMetaData();
        TestAllResultsImpl.assertEquals((int)2, (int)rmetadata.getColumnCount());
        String[] columnNames = this.columnNames();
        String[] dataTypes = this.dataTypes();
        for (int i = 0; i < 2; ++i) {
            TestAllResultsImpl.assertEquals((String)columnNames[i], (String)rmetadata.getColumnName(i + 1));
            TestAllResultsImpl.assertEquals((String)dataTypes[i], (String)rmetadata.getColumnTypeName(i + 1));
        }
        rs.close();
    }

    public void testResultsWarnings() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg2(), this.statement);
        rs.close();
    }

    public void testClose() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg2(), this.statement);
        rs.close();
        ((MMStatement)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.times((int)0))).close();
    }

    public void testGetFetchSize() {
        try {
            MMResultSet rs = new MMResultSet(this.exampleResultsMsg2(), this.statement);
            TestAllResultsImpl.assertEquals((int)500, (int)rs.getFetchSize());
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testIsAfterLast1() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1003);
        rs.last();
        boolean actual = rs.isAfterLast();
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        rs.close();
    }

    public void testAfterLast1() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1003);
        rs.afterLast();
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    public void testIsBeforeFirst1() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1003);
        boolean actual = rs.isBeforeFirst();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        rs.close();
    }

    public void testIsBeforeFirst2() throws Exception {
        MMResultSet rs = this.helpGetNoResults(1003);
        boolean actual = rs.isBeforeFirst();
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        rs.close();
    }

    public void testBeforeFirst1() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1003);
        rs.next();
        rs.beforeFirst();
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    public void testIsFirst1() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1003);
        rs.next();
        boolean actual = rs.isFirst();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        rs.close();
    }

    public void testIsFirst2() throws Exception {
        MMResultSet rs = this.helpGetNoResults(1003);
        rs.next();
        boolean actual = rs.isFirst();
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        rs.close();
    }

    public void testFirst1() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1003);
        rs.next();
        boolean actual = rs.first();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        rs.close();
    }

    public void testFirst2() throws Exception {
        MMResultSet rs = this.helpGetNoResults(1003);
        rs.next();
        boolean actual = rs.first();
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        rs.close();
    }

    public void testFindColumn() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg2a(), this.statement);
        TestAllResultsImpl.assertEquals((int)1, (int)rs.findColumn("IntNum"));
        rs.close();
    }

    public void testIsLast1() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1003);
        rs.last();
        boolean actual = rs.isLast();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        rs.close();
    }

    public void testIsLast2() throws Exception {
        MMResultSet rs = this.helpGetNoResults(1003);
        rs.last();
        boolean actual = rs.isLast();
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        rs.close();
    }

    public void testLast1() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1003);
        boolean actual = rs.last();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        rs.close();
    }

    public void testLast2() throws Exception {
        MMResultSet rs = this.helpGetNoResults(1003);
        boolean actual = rs.last();
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        rs.close();
    }

    public void testRelative1() throws Exception {
        MMResultSet rs = new MMResultSet(this.exampleResultsMsg2(), this.statement);
        rs.next();
        boolean actual = rs.relative(1);
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)2, (int)rs.getRow());
        actual = rs.relative(-1);
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getRow());
        rs.close();
    }

    public void testAbsolute1() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1003);
        boolean actual = rs.absolute(1);
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        rs.close();
    }

    public void testAbsolute2() throws Exception {
        MMResultSet rs = this.helpGetNoResults(1003);
        boolean actual = rs.absolute(1);
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        rs.close();
    }

    public void testAfterLast1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        rs.afterLast();
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    public void testIsAfterLast1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        rs.last();
        boolean actual = rs.isAfterLast();
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        rs.next();
        actual = rs.isAfterLast();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        rs.close();
    }

    public void testIsBeforeFirst1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.isBeforeFirst();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        rs.close();
    }

    public void testBeforeFirst1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        rs.next();
        rs.next();
        rs.beforeFirst();
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    public void testIsFirst1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        rs.next();
        boolean actual = rs.isFirst();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getRow());
        rs.close();
    }

    public void testFirst1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.first();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getRow());
        rs.afterLast();
        actual = rs.first();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getRow());
        rs.absolute(3);
        actual = rs.first();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getRow());
        rs.close();
    }

    public void testIsLast1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        rs.last();
        boolean actual = rs.isLast();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)5, (int)rs.getRow());
        rs.close();
    }

    public void testLast1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.last();
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)5, (int)rs.getRow());
        rs.close();
    }

    public void testRelative1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        rs.next();
        boolean actual = rs.relative(1);
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)2, (int)rs.getRow());
        actual = rs.relative(-1);
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getRow());
        rs.close();
    }

    public void testRelative1b() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        rs.next();
        boolean actual = rs.relative(1);
        actual = rs.relative(-1);
        actual = rs.relative(-3);
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.beforeFirst();
        rs.next();
        actual = rs.relative(7);
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    public void testRelative1c() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        try {
            rs.relative(-2);
            TestAllResultsImpl.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException e) {
            // empty catch block
        }
        TestAllResultsImpl.assertEquals((String)" Should still be before the first row ", (boolean)true, (boolean)rs.isBeforeFirst());
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        try {
            rs.relative(2);
            TestAllResultsImpl.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException e) {
            // empty catch block
        }
        TestAllResultsImpl.assertEquals((String)" Should still be before the first row ", (boolean)true, (boolean)rs.isBeforeFirst());
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.afterLast();
        try {
            rs.relative(2);
            TestAllResultsImpl.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException e) {
            // empty catch block
        }
        TestAllResultsImpl.assertEquals((String)" Should still be after the last row. ", (boolean)true, (boolean)rs.isAfterLast());
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        try {
            rs.relative(-2);
            TestAllResultsImpl.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestAllResultsImpl.assertEquals((String)" Should still be after the last row. ", (boolean)true, (boolean)rs.isAfterLast());
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    public void testAbsolute1a() throws Exception {
        MMResultSet rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.absolute(1);
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getRow());
        actual = rs.absolute(12);
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.afterLast();
        actual = rs.absolute(-1);
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)5, (int)rs.getRow());
        actual = rs.absolute(-2);
        TestAllResultsImpl.assertEquals((boolean)true, (boolean)actual);
        TestAllResultsImpl.assertEquals((int)4, (int)rs.getRow());
        rs.close();
    }

    public void testAbsolute2a() throws Exception {
        MMResultSet rs = this.helpGetNoResults(1005);
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)rs.absolute(1));
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.afterLast();
        TestAllResultsImpl.assertEquals((boolean)false, (boolean)rs.absolute(-1));
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    public void testProcessingTime() throws Exception {
        RequestMessage request = new RequestMessage();
        request.setProcessingTimestamp(new Date(12345678L));
        ResultsMessage resultsMsg = new ResultsMessage(request);
        resultsMsg.setColumnNames(new String[]{"IntNum"});
        resultsMsg.setDataTypes(new String[]{"integer"});
        long expectedProcessingTime = resultsMsg.getCompletedTimestamp().getTime() - resultsMsg.getProcessingTimestamp().getTime();
        Thread.sleep(200L);
        MMResultSet rs = new MMResultSet(resultsMsg, this.statement);
        long actualProcessingTime = rs.getProcessingTime();
        TestAllResultsImpl.assertEquals((long)expectedProcessingTime, (long)actualProcessingTime);
    }

    public void testMoreResults() throws Exception {
        int fetchSize = 5;
        int batchLength = 4;
        int totalLength = 10;
        MMResultSet rs = TestAllResultsImpl.helpTestBatching(this.statement, fetchSize, batchLength, totalLength);
        TestAllResultsImpl.assertTrue((boolean)rs.absolute(6));
        TestAllResultsImpl.assertTrue((boolean)rs.absolute(-1));
        TestAllResultsImpl.assertFalse((boolean)rs.next());
        for (int i = 0; i < totalLength; ++i) {
            TestAllResultsImpl.assertTrue((boolean)rs.previous());
        }
    }

    static MMResultSet helpTestBatching(MMStatement statement, int fetchSize, int batchLength, int totalLength) throws InterruptedException, ExecutionException, MetaMatrixProcessingException, SQLException {
        ClientSideDQP dqp = (ClientSideDQP)Mockito.mock(ClientSideDQP.class);
        Mockito.stub((Object)statement.getDQP()).toReturn((Object)dqp);
        for (int i = batchLength; i < totalLength; i += batchLength) {
            ResultsFuture nextBatch = (ResultsFuture)Mockito.mock(ResultsFuture.class);
            Mockito.stub((Object)nextBatch.get()).toReturn((Object)TestAllResultsImpl.exampleResultsMsg4(i + 1, Math.min(batchLength, totalLength - i), fetchSize, i + batchLength >= totalLength));
            Mockito.stub((Object)dqp.processCursorRequest(0L, i + 1, i + fetchSize)).toReturn((Object)nextBatch);
            if (i + batchLength >= totalLength) continue;
            ResultsFuture previousBatch = (ResultsFuture)Mockito.mock(ResultsFuture.class);
            Mockito.stub((Object)previousBatch.get()).toReturn((Object)TestAllResultsImpl.exampleResultsMsg4(i - batchLength + 1, i, fetchSize, false));
            Mockito.stub((Object)dqp.processCursorRequest(0L, i, i - fetchSize + 1)).toReturn((Object)previousBatch);
        }
        ResultsMessage msg = TestAllResultsImpl.exampleResultsMsg4(1, batchLength, fetchSize, batchLength == totalLength);
        MMResultSet rs = new MMResultSet(msg, statement);
        return rs;
    }

    static List<Object>[] exampleResults1(int length) {
        return TestAllResultsImpl.exampleResults1(length, 1);
    }

    static List<Object>[] exampleResults1(int length, int begin) {
        List[] results = new List[length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = new ArrayList();
            results[i].add(new Integer(begin + i));
        }
        return results;
    }

    private List[] exampleResults2() {
        List[] results = new List[5];
        for (int i = 0; i < results.length; ++i) {
            results[i] = new ArrayList();
            results[i].add(new Integer(i));
            results[i].add(new String("a" + i));
        }
        return results;
    }

    private String[] columnNames() {
        String[] names = new String[]{new String("IntNum"), new String("StringNum")};
        return names;
    }

    private String[] dataTypes() {
        String[] types = new String[]{"integer", "string"};
        return types;
    }

    private MMResultSet helpGetResultSetImpl(int type) throws SQLException {
        ResultsMessage rsMsg = this.exampleResultsMsg2();
        rsMsg.setCursorType(type);
        MMResultSet rs = new MMResultSet(rsMsg, this.statement);
        return rs;
    }

    private MMResultSet helpGetNoResults(int type) throws SQLException {
        ResultsMessage rsMsg = this.exampleResultsMsg3();
        rsMsg.setCursorType(type);
        MMResultSet rs = new MMResultSet(rsMsg, this.statement);
        return rs;
    }

    private ResultsMessage exampleResultsMsg1() {
        return this.exampleMessage(TestAllResultsImpl.exampleResults1(5), new String[]{"IntNum"}, new String[]{"integer"});
    }

    private ResultsMessage exampleMessage(List<Object>[] results, String[] columnNames, String[] datatypes) {
        RequestMessage request = new RequestMessage();
        request.setExecutionId(0L);
        ResultsMessage resultsMsg = new ResultsMessage(request);
        resultsMsg.setResults((List[])results);
        resultsMsg.setColumnNames(columnNames);
        resultsMsg.setDataTypes(datatypes);
        resultsMsg.setFinalRow(results.length);
        resultsMsg.setLastRow(results.length);
        resultsMsg.setFirstRow(1);
        resultsMsg.setFetchSize(500);
        resultsMsg.setCursorType(1004);
        return resultsMsg;
    }

    private ResultsMessage exampleResultsMsg2() {
        return this.exampleMessage(this.exampleResults2(), new String[]{"IntNum", "StringNum"}, new String[]{"integer", "string"});
    }

    private ResultsMessage exampleResultsMsg2a() {
        ResultsMessage resultsMsg = this.exampleResultsMsg2();
        List[] results = this.exampleResults2();
        resultsMsg.setDataTypes(this.dataTypes());
        resultsMsg.setColumnNames(this.columnNames());
        resultsMsg.setResults(results);
        resultsMsg.setFinalRow(results.length);
        resultsMsg.setLastRow(results.length);
        resultsMsg.setFirstRow(1);
        resultsMsg.setFetchSize(500);
        resultsMsg.setCursorType(1004);
        return resultsMsg;
    }

    private ResultsMessage exampleResultsMsg3() {
        return this.exampleMessage(new List[0], new String[]{"IntNum", "StringNum"}, new String[]{"integer", "string"});
    }

    private static ResultsMessage exampleResultsMsg4(int begin, int length, int fetchSize, boolean lastBatch) {
        RequestMessage request = new RequestMessage();
        request.setProcessingTimestamp(new Date(1L));
        request.setExecutionId(0L);
        ResultsMessage resultsMsg = new ResultsMessage(request);
        List[] results = TestAllResultsImpl.exampleResults1(length, begin);
        resultsMsg.setResults(results);
        resultsMsg.setColumnNames(new String[]{"IntKey"});
        resultsMsg.setDataTypes(new String[]{"integer"});
        resultsMsg.setPartialResults(false);
        resultsMsg.setFirstRow(begin);
        if (lastBatch) {
            resultsMsg.setFinalRow(begin + results.length - 1);
        }
        resultsMsg.setLastRow(begin + results.length - 1);
        resultsMsg.setFetchSize(fetchSize);
        resultsMsg.setCursorType(1004);
        return resultsMsg;
    }

    public void testNotCallingNext() throws SQLException {
        MMResultSet cs = new MMResultSet(this.exampleResultsMsg2a(), this.statement);
        try {
            cs.getObject(1);
            TestAllResultsImpl.fail((String)"Exception expected");
        }
        catch (SQLException e) {
            TestAllResultsImpl.assertEquals((String)"The cursor is not on a valid row.", (String)e.getMessage());
        }
    }

    public void testDateType() throws SQLException {
        RequestMessage request = new RequestMessage();
        request.setProcessingTimestamp(new Date(1L));
        request.setExecutionId(0L);
        ResultsMessage resultsMsg = new ResultsMessage(request);
        resultsMsg.setResults(new List[]{Arrays.asList(new Timestamp(0L))});
        resultsMsg.setColumnNames(new String[]{"TS"});
        resultsMsg.setDataTypes(new String[]{"timestamp"});
        resultsMsg.setPartialResults(false);
        resultsMsg.setFirstRow(1);
        resultsMsg.setFinalRow(1);
        resultsMsg.setLastRow(1);
        resultsMsg.setFetchSize(1);
        resultsMsg.setCursorType(1004);
        MMResultSet rs = new MMResultSet(resultsMsg, this.statement);
        TestAllResultsImpl.assertTrue((boolean)rs.next());
        TestAllResultsImpl.assertEquals((Object)new Timestamp(3600000L), (Object)rs.getObject(1));
        TestAllResultsImpl.assertEquals((Object)new Timestamp(0L), (Object)rs.getTimestamp(1, Calendar.getInstance(TimeZone.getTimeZone("GMT-05:00"))));
    }

    public void testWasNull() throws SQLException {
        ResultsMessage message = this.exampleMessage(new List[]{Arrays.asList(new String[]{null}), Arrays.asList("1")}, new String[]{"string"}, new String[]{"string"});
        MMResultSet rs = new MMResultSet(message, this.statement);
        TestAllResultsImpl.assertTrue((boolean)rs.next());
        TestAllResultsImpl.assertEquals((boolean)Boolean.FALSE, (boolean)rs.getBoolean(1));
        TestAllResultsImpl.assertTrue((boolean)rs.wasNull());
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getShort(1));
        TestAllResultsImpl.assertTrue((boolean)rs.wasNull());
        TestAllResultsImpl.assertEquals((int)0, (int)rs.getInt(1));
        TestAllResultsImpl.assertTrue((boolean)rs.wasNull());
        TestAllResultsImpl.assertEquals((long)0L, (long)rs.getLong(1));
        TestAllResultsImpl.assertTrue((boolean)rs.wasNull());
        TestAllResultsImpl.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(rs.getFloat(1)));
        TestAllResultsImpl.assertTrue((boolean)rs.wasNull());
        TestAllResultsImpl.assertEquals((Object)0.0, (Object)rs.getDouble(1));
        TestAllResultsImpl.assertTrue((boolean)rs.wasNull());
        TestAllResultsImpl.assertNull((Object)rs.getString(1));
        TestAllResultsImpl.assertTrue((boolean)rs.wasNull());
        TestAllResultsImpl.assertTrue((boolean)rs.next());
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getShort(1));
        TestAllResultsImpl.assertFalse((boolean)rs.wasNull());
        TestAllResultsImpl.assertFalse((boolean)rs.next());
    }

    public void testGetters() throws SQLException {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-05:00"));
        ResultsMessage message = this.exampleMessage(new List[]{Arrays.asList(1, TimestampUtil.createTime((int)0, (int)0, (int)0), TimestampUtil.createDate((int)1, (int)1, (int)1), TimestampUtil.createTimestamp((int)1, (int)1, (int)1, (int)1, (int)1, (int)1, (int)1), "<root/>")}, new String[]{"int", "time", "date", "timestamp", "sqlxml"}, new String[]{"integer", "time", "date", "timestamp", "string"});
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        MMResultSet rs = new MMResultSet(message, this.statement);
        TestAllResultsImpl.assertTrue((boolean)rs.next());
        TestAllResultsImpl.assertEquals((boolean)Boolean.TRUE, (boolean)rs.getBoolean(1));
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getShort(1));
        TestAllResultsImpl.assertEquals((int)1, (int)rs.getInt(1));
        TestAllResultsImpl.assertEquals((long)1L, (long)rs.getLong(1));
        TestAllResultsImpl.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(rs.getFloat(1)));
        TestAllResultsImpl.assertEquals((Object)1.0, (Object)rs.getDouble(1));
        TestAllResultsImpl.assertEquals((String)"1", (String)rs.getString(1));
        TestAllResultsImpl.assertEquals((Object)1, (Object)rs.getObject(1));
        TestAllResultsImpl.assertEquals((Object)TimestampUtil.createTime((int)0, (int)0, (int)0), (Object)rs.getTime(2));
        TestAllResultsImpl.assertEquals((Object)TimestampUtil.createDate((int)1, (int)1, (int)1), (Object)rs.getDate(3));
        TestAllResultsImpl.assertEquals((Object)TimestampUtil.createTimestamp((int)1, (int)1, (int)1, (int)1, (int)1, (int)1, (int)1), (Object)rs.getTimestamp(4));
        TestAllResultsImpl.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root/>", (String)rs.getSQLXML(5).getString());
        try {
            rs.getSQLXML(1);
        }
        catch (SQLException e) {
            TestAllResultsImpl.assertEquals((String)"Unable to transform the column value 1 to a SQLXML.", (String)e.getMessage());
        }
        TestAllResultsImpl.assertFalse((boolean)rs.next());
        TimestampWithTimezone.resetCalendar(null);
    }
}

