/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.jdbc.BatchFetcher;
import com.metamatrix.jdbc.BatchResults;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestBatchResults
extends TestCase {
    public TestBatchResults(String name) {
        super(name);
    }

    private static List[] createBatch(int begin, int end) {
        List[] results = new List[end - begin + 1];
        for (int i = 0; i < end - begin + 1; ++i) {
            results[i] = new ArrayList();
            results[i].add(new Integer(i + begin));
        }
        return results;
    }

    private List[] createEmptyBatch() {
        List[] results = new List[]{};
        return results;
    }

    public void testGetCurrentRow1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true, 100);
        TestBatchResults.assertNull((Object)batchResults.getCurrentRow());
        batchResults.next();
        TestBatchResults.assertNull((Object)batchResults.getCurrentRow());
    }

    public void testGetCurrentRow2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, true, 100);
        TestBatchResults.assertNull((Object)batchResults.getCurrentRow());
        batchResults.next();
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(1));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    public void testHasNext1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true, 100);
        TestBatchResults.assertFalse((boolean)batchResults.hasNext());
    }

    public void testHasNext2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true, 100);
        TestBatchResults.assertTrue((boolean)batchResults.hasNext());
    }

    public void testHasNext3() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, true, 100);
        TestBatchResults.assertTrue((boolean)batchResults.hasNext());
    }

    public void testNext1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true, 100);
        TestBatchResults.assertFalse((boolean)batchResults.next());
    }

    public void testNext2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true, 100);
        TestBatchResults.assertTrue((boolean)batchResults.next());
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(1));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        TestBatchResults.assertFalse((boolean)batchResults.next());
    }

    public void testNext3() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false, 100);
        batchResults.setBatchFetcher((BatchFetcher)new MockBatchFetcher());
        TestBatchResults.assertTrue((boolean)batchResults.next());
        TestBatchResults.assertTrue((boolean)batchResults.next());
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(2));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    public void testNext4() throws Exception {
        ArrayList<Integer> expectedResult;
        int i;
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, false, 100);
        batchResults.setBatchFetcher((BatchFetcher)new MockBatchFetcher());
        for (i = 0; i < 10; ++i) {
            TestBatchResults.assertTrue((boolean)batchResults.next());
            expectedResult = new ArrayList<Integer>();
            expectedResult.add(new Integer(i + 1));
            TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        }
        while (batchResults.next()) {
            expectedResult = new ArrayList();
            expectedResult.add(new Integer(i++ + 1));
            TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        }
        TestBatchResults.assertFalse((boolean)batchResults.next());
    }

    public void testHasPrevious1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true, 100);
        TestBatchResults.assertFalse((boolean)batchResults.hasPrevious());
    }

    public void testHasPrevious2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true, 100);
        TestBatchResults.assertFalse((boolean)batchResults.hasPrevious());
        batchResults.next();
        TestBatchResults.assertFalse((boolean)batchResults.hasPrevious());
        batchResults.next();
        TestBatchResults.assertTrue((boolean)batchResults.hasPrevious());
    }

    public void testPrevious1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true, 100);
        TestBatchResults.assertFalse((boolean)batchResults.previous());
    }

    public void testPrevious2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true, 100);
        TestBatchResults.assertTrue((boolean)batchResults.next());
        TestBatchResults.assertFalse((boolean)batchResults.previous());
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(1));
        while (batchResults.next()) {
        }
        TestBatchResults.assertTrue((boolean)batchResults.previous());
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    public void testPrevious3() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false, 100);
        batchResults.setBatchFetcher((BatchFetcher)new MockBatchFetcher());
        TestBatchResults.assertFalse((boolean)batchResults.previous());
        TestBatchResults.assertTrue((boolean)batchResults.next());
        TestBatchResults.assertFalse((boolean)batchResults.previous());
        while (batchResults.next()) {
        }
        TestBatchResults.assertTrue((boolean)batchResults.previous());
        while (batchResults.previous()) {
        }
        batchResults.next();
        batchResults.next();
        batchResults.next();
        batchResults.previous();
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(2));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    public void testPrevious4() throws Exception {
        int i;
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, false, 100);
        batchResults.setBatchFetcher((BatchFetcher)new MockBatchFetcher());
        for (i = 0; i <= 10; ++i) {
            TestBatchResults.assertTrue((boolean)batchResults.next());
        }
        for (i = 10; i > 0; --i) {
            batchResults.previous();
            ArrayList<Integer> expectedResult = new ArrayList<Integer>();
            expectedResult.add(new Integer(i));
            TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        }
    }

    public void testAbsolute1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true, 100);
        TestBatchResults.assertFalse((boolean)batchResults.absolute(0));
        TestBatchResults.assertFalse((boolean)batchResults.absolute(1));
    }

    public void testAbsolute2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true, 100);
        batchResults.setBatchFetcher((BatchFetcher)new MockBatchFetcher());
        TestBatchResults.assertFalse((boolean)batchResults.absolute(0));
        TestBatchResults.assertTrue((boolean)batchResults.absolute(1));
        TestBatchResults.assertTrue((boolean)batchResults.absolute(1));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(1));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    public void testAbsolute3() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, false, 100);
        batchResults.setBatchFetcher((BatchFetcher)new MockBatchFetcher(200));
        TestBatchResults.assertFalse((boolean)batchResults.absolute(0));
        TestBatchResults.assertTrue((boolean)batchResults.absolute(11));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(11));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        TestBatchResults.assertTrue((boolean)batchResults.absolute(1));
        expectedResult = new ArrayList();
        expectedResult.add(new Integer(1));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        TestBatchResults.assertTrue((boolean)batchResults.absolute(100));
        expectedResult = new ArrayList();
        expectedResult.add(new Integer(100));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    public void testAbsolute4() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false, 100);
        batchResults.setBatchFetcher((BatchFetcher)new MockBatchFetcher());
        TestBatchResults.assertTrue((boolean)batchResults.absolute(10));
        TestBatchResults.assertTrue((boolean)batchResults.absolute(2));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(2));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    public void testAbsolute5() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false, 100);
        batchResults.setBatchFetcher((BatchFetcher)new MockBatchFetcher());
        TestBatchResults.assertTrue((boolean)batchResults.absolute(-1));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(50));
        TestBatchResults.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        TestBatchResults.assertFalse((boolean)batchResults.absolute(-100));
    }

    public void testCurrentRowNumber() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true, 100);
        TestBatchResults.assertEquals((int)0, (int)batchResults.getCurrentRowNumber());
        batchResults.next();
        TestBatchResults.assertEquals((int)1, (int)batchResults.getCurrentRowNumber());
        batchResults.next();
        TestBatchResults.assertEquals((int)2, (int)batchResults.getCurrentRowNumber());
        TestBatchResults.assertFalse((boolean)batchResults.next());
        TestBatchResults.assertEquals((int)2, (int)batchResults.getCurrentRowNumber());
    }

    public void testSetException() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false, 100);
        MockBatchFetcher batchFetcher = new MockBatchFetcher();
        batchResults.setBatchFetcher((BatchFetcher)batchFetcher);
        batchFetcher.throwException();
        batchResults.next();
        try {
            batchResults.hasNext();
            TestBatchResults.fail((String)"Expected exception, but did not get.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testBatching() throws Exception {
        int i;
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, false, 10);
        MockBatchFetcher batchFetcher = new MockBatchFetcher(60);
        batchResults.setBatchFetcher((BatchFetcher)batchFetcher);
        for (i = 0; i < 45; ++i) {
            TestBatchResults.assertTrue((boolean)batchResults.next());
        }
        for (i = 0; i < 44; ++i) {
            TestBatchResults.assertTrue((boolean)batchResults.previous());
            TestBatchResults.assertEquals((Object)new Integer(44 - i), batchResults.getCurrentRow().get(0));
        }
        this.checkResults(new int[][]{{11, 20}, {21, 30}, {31, 40}, {41, 50}, {20, 11}, {10, 1}}, batchFetcher.batchCalls);
        TestBatchResults.assertTrue((boolean)batchResults.absolute(50));
        TestBatchResults.assertEquals((Object)new Integer(50), batchResults.getCurrentRow().get(0));
    }

    private void checkResults(int[][] expectedCalls, List<int[]> batchCalls) {
        TestBatchResults.assertEquals((int)expectedCalls.length, (int)batchCalls.size());
        for (int i = 0; i < batchCalls.size(); ++i) {
            int[] range = batchCalls.get(i);
            int[] expected = expectedCalls[i];
            TestBatchResults.assertEquals((String)("On call " + i + " expected different begin"), (int)expected[0], (int)range[0]);
            TestBatchResults.assertEquals((String)("On call " + i + " expected different end"), (int)expected[1], (int)range[1]);
        }
    }

    static class MockBatchFetcher
    implements BatchFetcher {
        private int totalRows = 50;
        private boolean throwException;
        List batchCalls = new ArrayList();

        public MockBatchFetcher() {
        }

        public MockBatchFetcher(int totalRows) {
            this.totalRows = totalRows;
        }

        public BatchResults.Batch requestBatch(int beginRow, int endRow) throws SQLException {
            this.batchCalls.add(new int[]{beginRow, endRow});
            if (this.throwException) {
                throw new SQLException();
            }
            boolean isLast = false;
            if (beginRow > endRow) {
                if (endRow < 1) {
                    endRow = 1;
                }
                int i = beginRow;
                beginRow = endRow;
                endRow = i;
            } else if (endRow > this.totalRows) {
                endRow = this.totalRows;
                isLast = true;
            }
            return new BatchResults.Batch(TestBatchResults.createBatch(beginRow, endRow), beginRow, endRow, isLast);
        }

        public void throwException() {
            this.throwException = true;
        }
    }
}

