/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.dqp.message.ParameterInfo;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.MMCallableStatement;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.platform.security.api.LogonResult;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class TestMMCallableStatement
extends TestCase {
    public void testWasNull() throws Exception {
        MMResultSet rs;
        HashMap<Integer, Integer> params;
        MMCallableStatement mmcs = this.getCallableStatement();
        mmcs.outParamIndexMap = params = new HashMap<Integer, Integer>();
        params.put(1, 1);
        params.put(2, 2);
        mmcs.resultSet = rs = (MMResultSet)Mockito.mock(MMResultSet.class);
        Mockito.stub((Object)rs.getOutputParamValue(1)).toReturn(null);
        Mockito.stub((Object)rs.getOutputParamValue(2)).toReturn((Object)Boolean.TRUE);
        mmcs.getBoolean(1);
        TestMMCallableStatement.assertTrue((boolean)mmcs.wasNull());
        TestMMCallableStatement.assertTrue((boolean)mmcs.getBoolean(2));
        TestMMCallableStatement.assertFalse((boolean)mmcs.wasNull());
    }

    public void testGetOutputParameter() throws Exception {
        MMCallableStatement mmcs = this.getCallableStatement();
        RequestMessage request = new RequestMessage();
        request.setExecutionId(1L);
        ResultsMessage resultsMsg = new ResultsMessage(request);
        List[] results = new List[]{Arrays.asList(null, null, null), Arrays.asList(null, 1, 2)};
        resultsMsg.setResults(results);
        resultsMsg.setColumnNames(new String[]{"IntNum", "Out1", "Out2"});
        resultsMsg.setDataTypes(new String[]{"integer", "integer", "integer"});
        resultsMsg.setFinalRow(results.length);
        resultsMsg.setLastRow(results.length);
        resultsMsg.setFirstRow(1);
        resultsMsg.setParameters(Arrays.asList(new ParameterInfo(5, 1), new ParameterInfo(2, 1), new ParameterInfo(2, 1)));
        mmcs.createResultSet(resultsMsg);
        TestMMCallableStatement.assertEquals((int)1, (int)mmcs.getInt(1));
        TestMMCallableStatement.assertEquals((int)2, (int)mmcs.getInt(2));
    }

    public void testUnknownIndex() throws Exception {
        MMCallableStatement mmcs = this.getCallableStatement();
        mmcs.outParamIndexMap = new HashMap();
        try {
            mmcs.getBoolean(0);
            TestMMCallableStatement.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            TestMMCallableStatement.assertEquals((String)"Parameter is not found at index 0.", (String)e.getMessage());
        }
    }

    private MMCallableStatement getCallableStatement() throws SQLException {
        MMConnection conn = (MMConnection)Mockito.mock(MMConnection.class);
        ServerConnection sc = (ServerConnection)Mockito.mock(ServerConnection.class);
        Mockito.stub((Object)sc.getLogonResult()).toReturn((Object)new LogonResult());
        Mockito.stub((Object)conn.getServerConnection()).toReturn((Object)sc);
        MMCallableStatement mmcs = new MMCallableStatement(conn, "{?=call x(?)}", 1003, 1007);
        return mmcs;
    }
}

