/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.jdbc.MMServerConnection;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class TestMMConnection
extends TestCase {
    protected static final String STD_DATABASE_NAME = "QT_Ora9DS";
    protected static final String STD_DATABASE_VERSION = "1";
    static String serverUrl = "jdbc:metamatrix:QT_Ora9DS@mm://localhost:7001;version=1;user=metamatrixadmin;password=mm";

    public TestMMConnection(String name) {
        super(name);
        System.setProperty("metamatrix.config.none", "true");
    }

    public static MMServerConnection getMMConnection() throws SQLException {
        ServerConnection mock = (ServerConnection)Mockito.mock(ServerConnection.class);
        Mockito.stub((Object)mock.getService(ClientSideDQP.class)).toReturn(Mockito.mock(ClientSideDQP.class));
        Properties props = new Properties();
        props.setProperty("VirtualDatabaseName", STD_DATABASE_NAME);
        props.setProperty("VirtualDatabaseVersion", STD_DATABASE_VERSION);
        props.setProperty("user", "metamatrixadmin");
        Properties productInfo = new Properties();
        productInfo.setProperty("VirtualDatabaseName", STD_DATABASE_NAME);
        productInfo.setProperty("VirtualDatabaseVersion", STD_DATABASE_VERSION);
        Mockito.stub((Object)mock.getLogonResult()).toReturn((Object)new LogonResult(new MetaMatrixSessionID(1L), "metamatrixadmin", productInfo, 1L, "fake"));
        return new MMServerConnection(mock, props, serverUrl);
    }

    public void testGetMetaData() throws Exception {
        TestMMConnection.assertNotNull((Object)TestMMConnection.getMMConnection().getMetaData());
    }

    public void testGetSchema() throws Exception {
        TestMMConnection.assertEquals((String)"Actual schema is not equql to the expected one. ", (String)STD_DATABASE_NAME, (String)TestMMConnection.getMMConnection().getSchema());
    }

    public void testNativeSql() throws Exception {
        String sql = "SELECT * FROM BQT1.SmallA";
        TestMMConnection.assertEquals((String)"Actual schema is not equql to the expected one. ", (String)sql, (String)TestMMConnection.getMMConnection().nativeSQL(sql));
    }

    public void testGetUserName2() throws Exception {
        TestMMConnection.assertEquals((String)"Actual userName is not equal to the expected one. ", (String)"metamatrixadmin", (String)TestMMConnection.getMMConnection().getUserName());
    }

    public void testIsReadOnly() throws Exception {
        TestMMConnection.assertEquals((boolean)false, (boolean)TestMMConnection.getMMConnection().isReadOnly());
    }

    public void testSetReadOnly1() throws Exception {
        MMServerConnection conn = TestMMConnection.getMMConnection();
        conn.setReadOnly(true);
        TestMMConnection.assertEquals((boolean)true, (boolean)conn.isReadOnly());
    }

    public void testSetReadOnly2() throws Exception {
        MMServerConnection conn = TestMMConnection.getMMConnection();
        conn.setAutoCommit(false);
        try {
            conn.setReadOnly(true);
            TestMMConnection.fail((String)"Error Expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

