/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.jdbc.MMDataSource;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.TestCase;

public class TestMMDataSource
extends TestCase {
    protected static final boolean VALID = true;
    protected static final boolean INVALID = false;
    private MMDataSource dataSource;
    protected static final String STD_SERVER_NAME = "unitTestServerName";
    protected static final String STD_DATABASE_NAME = "unitTestVdbName";
    protected static final String STD_DATABASE_VERSION = "unitTestVdbVersion";
    protected static final String STD_DATA_SOURCE_NAME = "unitTestDataSourceName";
    protected static final int STD_PORT_NUMBER = 7001;
    protected static final String STD_LOG_FILE = UnitTestUtil.getTestScratchPath() + "/unitTestLogFile";
    protected static final int STD_LOG_LEVEL = 2;
    protected static final String STD_TXN_AUTO_WRAP = "PESSIMISTIC";
    protected static final String STD_PARTIAL_MODE = "false";
    protected static final String STD_CONFIG_FILE = UnitTestUtil.getTestDataPath() + "/bqt/bqt.properties";
    protected static final String STD_ALTERNATE_SERVERS = "unitTestServerName2:7001,unitTestServerName2:7002,unitTestServerName3:7001";

    public TestMMDataSource(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dataSource = new MMDataSource();
        this.dataSource.setServerName(STD_SERVER_NAME);
        this.dataSource.setDatabaseVersion(STD_DATABASE_VERSION);
        this.dataSource.setDatabaseName(STD_DATABASE_NAME);
        this.dataSource.setPortNumber(7001);
        this.dataSource.setDataSourceName(STD_DATA_SOURCE_NAME);
        this.dataSource.setTransactionAutoWrap(STD_TXN_AUTO_WRAP);
        this.dataSource.setPartialResultsMode(STD_PARTIAL_MODE);
        this.dataSource.setSecure(true);
        this.dataSource.setAlternateServers(STD_ALTERNATE_SERVERS);
    }

    protected String getReasonWhyInvalid(String propertyName, String value) {
        if (propertyName.equals("DatabaseName")) {
            return MMDataSource.reasonWhyInvalidDatabaseName((String)value);
        }
        if (propertyName.equals("DatabaseVersion")) {
            return MMDataSource.reasonWhyInvalidDatabaseVersion((String)value);
        }
        if (propertyName.equals("DataSourceName")) {
            return MMDataSource.reasonWhyInvalidDataSourceName((String)value);
        }
        if (propertyName.equals("Description")) {
            return MMDataSource.reasonWhyInvalidDescription((String)value);
        }
        if (propertyName.equals("ServerName")) {
            return MMDataSource.reasonWhyInvalidServerName((String)value);
        }
        if (propertyName.equals("TransactionAutoWrap")) {
            return MMDataSource.reasonWhyInvalidTransactionAutoWrap((String)value);
        }
        if (propertyName.equals("partialResultsMode")) {
            return MMDataSource.reasonWhyInvalidPartialResultsMode((String)value);
        }
        if (propertyName.equals("socketsPerVM")) {
            return MMDataSource.reasonWhyInvalidSocketsPerVM((String)value);
        }
        if (propertyName.equals("stickyConnections")) {
            return MMDataSource.reasonWhyInvalidStickyConnections((String)value);
        }
        if (propertyName.equals("alternateServers")) {
            return MMDataSource.reasonWhyInvalidAlternateServers((String)value);
        }
        TestMMDataSource.fail((String)("Unknown property name \"" + propertyName + "\""));
        return null;
    }

    protected String getReasonWhyInvalid(String propertyName, int value) {
        if (propertyName.equals("PortNumber")) {
            return MMDataSource.reasonWhyInvalidPortNumber((int)value);
        }
        TestMMDataSource.fail((String)("Unknown property name \"" + propertyName + "\""));
        return null;
    }

    public void helpTestReasonWhyInvalid(String propertyName, String value, boolean shouldBeValid) {
        String reason = this.getReasonWhyInvalid(propertyName, value);
        if (shouldBeValid) {
            TestMMDataSource.assertNull((String)("Unexpectedly considered invalid value \"" + value + "\"; reason = " + reason), (Object)reason);
        } else {
            TestMMDataSource.assertNotNull((String)("Unexpectedly found no reason for value \"" + value + "\""), (Object)reason);
        }
    }

    public void helpTestReasonWhyInvalid(String propertyName, int value, boolean shouldBeValid) {
        String reason = this.getReasonWhyInvalid(propertyName, value);
        if (shouldBeValid) {
            TestMMDataSource.assertNull((String)("Unexpectedly considered invalid value " + value + "; reason = " + reason), (Object)reason);
        } else {
            TestMMDataSource.assertNotNull((String)("Unexpectedly found no reason for value " + value), (Object)reason);
        }
    }

    public void helpTestBuildingURL(String vdbName, String vdbVersion, String serverName, int portNumber, String alternateServers, String txnAutoWrap, String partialMode, int fetchSize, boolean showPlan, boolean secure, String expectedURL) {
        MMDataSource ds = new MMDataSource();
        ds.setServerName(serverName);
        ds.setDatabaseVersion(vdbVersion);
        ds.setDatabaseName(vdbName);
        ds.setPortNumber(portNumber);
        ds.setFetchSize(fetchSize);
        ds.setTransactionAutoWrap(txnAutoWrap);
        ds.setPartialResultsMode(partialMode);
        if (showPlan) {
            ds.setSqlOptions("SHOWPLAN");
        }
        ds.setSecure(secure);
        ds.setAlternateServers(alternateServers);
        String url = ds.buildURL();
        TestMMDataSource.assertEquals((String)expectedURL, (String)url);
    }

    public Connection helpTestConnection(String vdbName, String vdbVersion, String serverName, int portNumber, String alternateServers, String user, String password, String dataSourceName, String txnAutoWrap, String partialMode, String configFile) throws SQLException {
        MMDataSource ds = new MMDataSource();
        ds.setServerName(serverName);
        ds.setDatabaseVersion(vdbVersion);
        ds.setDatabaseName(vdbName);
        ds.setPortNumber(portNumber);
        ds.setUser(user);
        ds.setPassword(password);
        ds.setDataSourceName(dataSourceName);
        ds.setTransactionAutoWrap(txnAutoWrap);
        ds.setPartialResultsMode(partialMode);
        ds.setAlternateServers(alternateServers);
        return ds.getConnection();
    }

    public void helpTestToString(MMDataSource ds) {
        String s = null;
        String url = null;
        String urlWithoutPrefix = null;
        try {
            s = ds.toString();
        }
        catch (Exception e) {
            TestMMDataSource.fail((String)"Unable to perform 'toString'");
        }
        try {
            url = ds.buildURL();
            urlWithoutPrefix = url.substring("jdbc:metamatrix:".length());
        }
        catch (Exception e) {
            TestMMDataSource.fail((String)"Unable to perform 'buildURL'");
        }
        TestMMDataSource.assertEquals(urlWithoutPrefix, (String)s);
    }

    public void testToString1() {
        this.helpTestToString(this.dataSource);
    }

    public void testGetServerName() {
        String result = this.dataSource.getServerName();
        TestMMDataSource.assertEquals((String)result, (String)STD_SERVER_NAME);
    }

    public void testGetDatabaseVersion() {
        String result = this.dataSource.getDatabaseVersion();
        TestMMDataSource.assertEquals((String)result, (String)STD_DATABASE_VERSION);
    }

    public void testGetDatabaseName() {
        String result = this.dataSource.getDatabaseName();
        TestMMDataSource.assertEquals((String)result, (String)STD_DATABASE_NAME);
    }

    public void testGetPortNumber() {
        int result = this.dataSource.getPortNumber();
        TestMMDataSource.assertEquals((int)result, (int)7001);
    }

    public void testGetDataSourceName() {
        String result = this.dataSource.getDataSourceName();
        TestMMDataSource.assertEquals((String)result, (String)STD_DATA_SOURCE_NAME);
    }

    public void testGetLoginTimeout() {
        try {
            int actual = 1000;
            this.dataSource.setLoginTimeout(1000);
            int result = this.dataSource.getLoginTimeout();
            TestMMDataSource.assertEquals((int)result, (int)1000);
        }
        catch (SQLException e) {
            TestMMDataSource.fail((String)"Error obtaining login timeout");
        }
    }

    public void testGetLogWriter() {
        try {
            PrintWriter actual = new PrintWriter(new ByteArrayOutputStream());
            this.dataSource.setLogWriter(actual);
            PrintWriter result = this.dataSource.getLogWriter();
            TestMMDataSource.assertEquals((Object)result, (Object)actual);
        }
        catch (SQLException e) {
            TestMMDataSource.fail((String)"Error obtaining login timeout");
        }
    }

    public void testGetTransactionAutoWrap() {
        String result = this.dataSource.getTransactionAutoWrap();
        TestMMDataSource.assertEquals((String)result, (String)STD_TXN_AUTO_WRAP);
    }

    public void testGetShowPlan() {
        TestMMDataSource.assertTrue((this.dataSource.getSqlOptions() == null ? 1 : 0) != 0);
        this.dataSource.setSqlOptions("SHOWPLAN");
        TestMMDataSource.assertTrue((this.dataSource.getSqlOptions() == "SHOWPLAN" ? 1 : 0) != 0);
        this.dataSource.setSqlOptions(null);
        TestMMDataSource.assertTrue((this.dataSource.getSqlOptions() == null ? 1 : 0) != 0);
    }

    public void testGetSecure() {
        TestMMDataSource.assertTrue((boolean)this.dataSource.isSecure());
        this.dataSource.setSecure(false);
        TestMMDataSource.assertFalse((boolean)this.dataSource.isSecure());
    }

    public void testGetAlternateServers() {
        String result = this.dataSource.getAlternateServers();
        TestMMDataSource.assertEquals((String)result, (String)STD_ALTERNATE_SERVERS);
        this.dataSource.setAlternateServers(null);
        result = this.dataSource.getAlternateServers();
        TestMMDataSource.assertNull((Object)result);
        this.dataSource.setAlternateServers(STD_ALTERNATE_SERVERS);
        result = this.dataSource.getAlternateServers();
        TestMMDataSource.assertEquals((String)result, (String)STD_ALTERNATE_SERVERS);
    }

    public void testReasonWhyInvalidDatabaseName1() {
        this.helpTestReasonWhyInvalid("DatabaseName", "Valid VDB Name", true);
    }

    public void testReasonWhyInvalidDatabaseName2() {
        this.helpTestReasonWhyInvalid("DatabaseName", "", false);
    }

    public void testReasonWhyInvalidDatabaseName3() {
        this.helpTestReasonWhyInvalid("DatabaseName", null, false);
    }

    public void testReasonWhyInvalidDatabaseVersion1() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "Valid VDB Version", true);
    }

    public void testReasonWhyInvalidDatabaseVersion2() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "1", true);
    }

    public void testReasonWhyInvalidDatabaseVersion3() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "1.2.3", true);
    }

    public void testReasonWhyInvalidDatabaseVersion4() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "1 2 3", true);
    }

    public void testReasonWhyInvalidDatabaseVersion5() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "", true);
    }

    public void testReasonWhyInvalidDatabaseVersion6() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", null, true);
    }

    public void testReasonWhyInvalidDataSourceName1() {
        this.helpTestReasonWhyInvalid("DataSourceName", "Valid Data Source Name", true);
    }

    public void testReasonWhyInvalidDataSourceName2() {
        this.helpTestReasonWhyInvalid("DataSourceName", "", true);
    }

    public void testReasonWhyInvalidDataSourceName3() {
        this.helpTestReasonWhyInvalid("DataSourceName", "", true);
    }

    public void testReasonWhyInvalidDescription1() {
        this.helpTestReasonWhyInvalid("Description", "Valid App Name", true);
    }

    public void testReasonWhyInvalidDescription2() {
        this.helpTestReasonWhyInvalid("Description", "", true);
    }

    public void testReasonWhyInvalidDescription3() {
        this.helpTestReasonWhyInvalid("Description", null, true);
    }

    public void testReasonWhyInvalidPortNumber1() {
        this.helpTestReasonWhyInvalid("PortNumber", 1, true);
    }

    public void testReasonWhyInvalidPortNumber2() {
        this.helpTestReasonWhyInvalid("PortNumber", 9999999, true);
    }

    public void testReasonWhyInvalidPortNumber3() {
        this.helpTestReasonWhyInvalid("PortNumber", 0, true);
    }

    public void testReasonWhyInvalidPortNumber4() {
        this.helpTestReasonWhyInvalid("PortNumber", -1, false);
    }

    public void testReasonWhyInvalidServerName1() {
        this.helpTestReasonWhyInvalid("ServerName", "Valid Server Name", true);
    }

    public void testReasonWhyInvalidServerName2() {
        this.helpTestReasonWhyInvalid("ServerName", "Valid Server Name", true);
    }

    public void testReasonWhyInvalidServerName3() {
        this.helpTestReasonWhyInvalid("ServerName", "", false);
    }

    public void testReasonWhyInvalidServerName4() {
        this.helpTestReasonWhyInvalid("ServerName", null, false);
    }

    public void testReasonWhyInvalidTransactionAutoWrap1() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", "OFF", true);
    }

    public void testReasonWhyInvalidTransactionAutoWrap2() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", "ON", true);
    }

    public void testReasonWhyInvalidTransactionAutoWrap3() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", "OPTIMISTIC", true);
    }

    public void testReasonWhyInvalidTransactionAutoWrap4() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", STD_TXN_AUTO_WRAP, true);
    }

    public void testReasonWhyInvalidTransactionAutoWrap5() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", "off", false);
    }

    public void testReasonWhyInvalidTransactionAutoWrap6() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", "Invalid AutoWrap", false);
    }

    public void testreasonWhyInvalidPartialResultsMode1() {
        this.helpTestReasonWhyInvalid("partialResultsMode", "Invalid partial mode", false);
    }

    public void testreasonWhyInvalidPartialResultsMode2() {
        this.helpTestReasonWhyInvalid("partialResultsMode", "true", true);
    }

    public void testReasonWhyInvalidSocketsPerVM1() {
        this.helpTestReasonWhyInvalid("socketsPerVM", null, true);
    }

    public void testReasonWhyInvalidSocketsPerVM2() {
        this.helpTestReasonWhyInvalid("socketsPerVM", "4", true);
    }

    public void testReasonWhyInvalidSocketsPerVM3() {
        this.helpTestReasonWhyInvalid("socketsPerVM", "-3", false);
    }

    public void testReasonWhyInvalidSocketsPerVM4() {
        this.helpTestReasonWhyInvalid("socketsPerVM", "5.6", false);
    }

    public void testReasonWhyInvalidStickyConnections1() {
        this.helpTestReasonWhyInvalid("stickyConnections", null, true);
    }

    public void testReasonWhyInvalidStickyConnections2() {
        this.helpTestReasonWhyInvalid("stickyConnections", STD_PARTIAL_MODE, true);
    }

    public void testReasonWhyInvalidStickyConnections3() {
        this.helpTestReasonWhyInvalid("stickyConnections", "YES", false);
    }

    public void testReasonWhyInvalidAlternateServers1() {
        this.helpTestReasonWhyInvalid("alternateServers", null, true);
    }

    public void testReasonWhyInvalidAlternateServers2() {
        this.helpTestReasonWhyInvalid("alternateServers", "", true);
    }

    public void testReasonWhyInvalidAlternateServers3() {
        this.helpTestReasonWhyInvalid("alternateServers", "server", true);
    }

    public void testReasonWhyInvalidAlternateServers4() {
        this.helpTestReasonWhyInvalid("alternateServers", "server:100", true);
    }

    public void testReasonWhyInvalidAlternateServers5() {
        this.helpTestReasonWhyInvalid("alternateServers", "server:port", false);
    }

    public void testReasonWhyInvalidAlternateServers6() {
        this.helpTestReasonWhyInvalid("alternateServers", "server:100:1", false);
    }

    public void testReasonWhyInvalidAlternateServers7() {
        this.helpTestReasonWhyInvalid("alternateServers", "server:100:abc", false);
    }

    public void testReasonWhyInvalidAlternateServers8() {
        this.helpTestReasonWhyInvalid("alternateServers", "server:abc:100", false);
    }

    public void testReasonWhyInvalidAlternateServers9() {
        this.helpTestReasonWhyInvalid("alternateServers", ":100", false);
    }

    public void testReasonWhyInvalidAlternateServers10() {
        this.helpTestReasonWhyInvalid("alternateServers", ":abc", false);
    }

    public void testReasonWhyInvalidAlternateServers11() {
        this.helpTestReasonWhyInvalid("alternateServers", "server1:100,server2", true);
    }

    public void testReasonWhyInvalidAlternateServers12() {
        this.helpTestReasonWhyInvalid("alternateServers", "server1:100,server2:101", true);
    }

    public void testReasonWhyInvalidAlternateServers13() {
        this.helpTestReasonWhyInvalid("alternateServers", "server1:100,", true);
    }

    public void testReasonWhyInvalidAlternateServers14() {
        this.helpTestReasonWhyInvalid("alternateServers", "server1:100,server2:abc", false);
    }

    public void testReasonWhyInvalidAlternateServers15() {
        this.helpTestReasonWhyInvalid("alternateServers", "server1:100,server2:101:abc", false);
    }

    public void testReasonWhyInvalidAlternateServers16() {
        this.helpTestReasonWhyInvalid("alternateServers", "server1,server2:100", true);
    }

    public void testReasonWhyInvalidAlternateServers17() {
        this.helpTestReasonWhyInvalid("alternateServers", "server1,server2", true);
    }

    public void testReasonWhyInvalidAlternateServers18() {
        this.helpTestReasonWhyInvalid("alternateServers", ",server2:100", false);
    }

    public void testReasonWhyInvalidAlternateServers19() {
        this.helpTestReasonWhyInvalid("alternateServers", "server1,server2,server3,server4:500", true);
    }

    public void testBuildingURL1() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "1.2.3";
        int portNumber = 7001;
        String transactionAutoWrap = null;
        String partialMode = "true";
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "1.2.3", "hostName", 7001, null, transactionAutoWrap, "true", 500, false, false, "jdbc:metamatrix:vdbName@mm://hostname:7001;fetchSize=500;serverURL=mm://hostname:7001;VirtualDatabaseVersion=1.2.3;partialResultsMode=true;VirtualDatabaseName=vdbName");
    }

    public void testBuildingURL2() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String transactionAutoWrap = STD_TXN_AUTO_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, null, STD_TXN_AUTO_WRAP, STD_PARTIAL_MODE, -1, false, false, "jdbc:metamatrix:vdbName@mm://hostname:7001;serverURL=mm://hostname:7001;txnAutoWrap=PESSIMISTIC;partialResultsMode=false;VirtualDatabaseName=vdbName");
    }

    public void testBuildURL3() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String transactionAutoWrap = STD_TXN_AUTO_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, null, STD_TXN_AUTO_WRAP, STD_PARTIAL_MODE, -1, true, false, "jdbc:metamatrix:vdbName@mm://hostname:7001;serverURL=mm://hostname:7001;txnAutoWrap=PESSIMISTIC;partialResultsMode=false;VirtualDatabaseName=vdbName;sqlOptions=SHOWPLAN");
    }

    public void testBuildURL4() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String transactionAutoWrap = STD_TXN_AUTO_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = true;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, null, STD_TXN_AUTO_WRAP, STD_PARTIAL_MODE, -1, true, true, "jdbc:metamatrix:vdbName@mms://hostname:7001;serverURL=mms://hostname:7001;txnAutoWrap=PESSIMISTIC;partialResultsMode=false;VirtualDatabaseName=vdbName;sqlOptions=SHOWPLAN");
    }

    public void testBuildURL5() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String alternateServers = "hostName:7002,hostName2:7001,hostName2:7002";
        String transactionAutoWrap = STD_TXN_AUTO_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, "hostName:7002,hostName2:7001,hostName2:7002", STD_TXN_AUTO_WRAP, STD_PARTIAL_MODE, -1, true, false, "jdbc:metamatrix:vdbName@mm://hostName:7001,hostName:7002,hostName2:7001,hostName2:7002;serverURL=mm://hostName:7001,hostName:7002,hostName2:7001,hostName2:7002;txnAutoWrap=PESSIMISTIC;partialResultsMode=false;VirtualDatabaseName=vdbName;sqlOptions=SHOWPLAN");
    }

    public void testBuildURL6() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String alternateServers = "hostName:7002,hostName2:7001,hostName2:7002";
        String transactionAutoWrap = STD_TXN_AUTO_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = true;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, "hostName:7002,hostName2:7001,hostName2:7002", STD_TXN_AUTO_WRAP, STD_PARTIAL_MODE, -1, true, true, "jdbc:metamatrix:vdbName@mms://hostName:7001,hostName:7002,hostName2:7001,hostName2:7002;serverURL=mms://hostName:7001,hostName:7002,hostName2:7001,hostName2:7002;txnAutoWrap=PESSIMISTIC;partialResultsMode=false;VirtualDatabaseName=vdbName;sqlOptions=SHOWPLAN");
    }

    public void testBuildURL7() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String alternateServers = "hostName:7002,hostName2,hostName2:7002";
        String transactionAutoWrap = STD_TXN_AUTO_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, "hostName:7002,hostName2,hostName2:7002", STD_TXN_AUTO_WRAP, STD_PARTIAL_MODE, -1, true, false, "jdbc:metamatrix:vdbName@mm://hostName:7001,hostName:7002,hostName2:7001,hostName2:7002;serverURL=mm://hostName:7001,hostName:7002,hostName2:7001,hostName2:7002;txnAutoWrap=PESSIMISTIC;partialResultsMode=false;VirtualDatabaseName=vdbName;sqlOptions=SHOWPLAN");
    }

    public void testBuildURL_AdditionalProperties() {
        MMDataSource ds = new MMDataSource();
        ds.setAdditionalProperties("foo=bar;a=b");
        ds.setServerName("hostName");
        ds.setDatabaseName("vdbName");
        ds.setPortNumber(1);
        TestMMDataSource.assertEquals((String)"jdbc:metamatrix:vdbName@mm://hostname:1;fetchSize=2000;serverURL=mm://hostname:1;a=b;VirtualDatabaseName=vdbName;foo=bar", (String)ds.buildURL());
    }

    public void testInvalidDataSource() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = -1;
        String dataSourceName = null;
        String transactionAutoWrap = null;
        String configFile = UnitTestUtil.getTestDataPath() + "/config.txt";
        try {
            this.helpTestConnection("vdbName", "", "hostName", -1, null, null, null, dataSourceName, transactionAutoWrap, STD_PARTIAL_MODE, configFile);
            TestMMDataSource.fail((String)"Unexpectedly able to connect");
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    public void testInvalidDataSource2() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 31000;
        String alternateServers = "hostName:-1";
        String dataSourceName = null;
        String transactionAutoWrap = null;
        String configFile = UnitTestUtil.getTestDataPath() + "/config.txt";
        try {
            this.helpTestConnection("vdbName", "", "hostName", 31000, "hostName:-1", null, null, dataSourceName, transactionAutoWrap, STD_PARTIAL_MODE, configFile);
            TestMMDataSource.fail((String)"Unexpectedly able to connect");
        }
        catch (SQLException e) {
            // empty catch block
        }
    }
}

