/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.jdbc.MMDriver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.TestCase;

public class TestMMDriver
extends TestCase {
    MMDriver drv = new MMDriver();
    public String localhost = "localhost";

    public TestMMDriver(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    public void testAcceptsURL1() throws Exception {
        TestMMDriver.assertNotNull((Object)this.drv);
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:jvdb@mm://localhost:1234"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://localhost:1234;version=x"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://localhost:1234"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mms://localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;txnAutoWrap=OFF;paritalResultsMode=true"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:jvdb@mms://localhost:1234"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://localhost:1234;version=x"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mms://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mms://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;txnAutoWrap=OFF;paritalResultsMode=true"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://127.0.0.1:1234;logLevel=2"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mms://127.0.0.1:1234"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://127.0.0.1:1234,localhost.mydomain.com:63636;logLevel=2"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://my-host.mydomain.com:53535,127.0.0.1:1234"));
        TestMMDriver.assertTrue((boolean)this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://123.123.123.123:53535,127.0.0.1:1234"));
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:jvdb@c:/dqp.properties;version=1") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:jvdb@/foo/dqp.properties;version=1") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:jvdb@../foo/dqp.properties;version=1") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:jvdb@mm://localhost:port") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:vdb@localhost:port;version=x") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:@localhost:1234") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:@localhost:1234,localhost2:12342,localhost3:12343") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:@localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:@localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:@localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;txnAutoWrap=OFF;paritalResultsMode=true") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:@localhost:1234;stickyConnections=false;socketsPerVM=4") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:metamatrix:vdb@mm://my_host.mydomain.com:53535,127.0.0.1:1234") ? 1 : 0) != 0);
    }

    public void testAcceptsURL2() throws Exception {
        TestMMDriver.assertNotNull((Object)this.drv);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc:matamatrix:test") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("metamatrix:test") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc&matamatrix:test") ? 1 : 0) != 0);
        TestMMDriver.assertTrue((!this.drv.acceptsURL("jdbc;metamatrix:test") ? 1 : 0) != 0);
    }

    public void testParseURL() throws SQLException {
        Properties p = new Properties();
        MMDriver.getInstance().parseURL("jdbc:metamatrix:BQT@mm://slwxp157:1234", p);
        TestMMDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestMMDriver.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234"));
        TestMMDriver.assertEquals((int)2, (int)p.size());
    }

    public void testParseURL2() throws SQLException {
        Properties p = new Properties();
        MMDriver.getInstance().parseURL("jdbc:metamatrix:BQT@mms://slwxp157:1234;version=3", p);
        TestMMDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestMMDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        TestMMDriver.assertTrue((boolean)p.getProperty("serverURL").equals("mms://slwxp157:1234"));
        TestMMDriver.assertTrue((boolean)p.getProperty("version").equals("3"));
        TestMMDriver.assertEquals((int)4, (int)p.size());
    }

    public void testParseURL3() throws SQLException {
        Properties p = new Properties();
        MMDriver.getInstance().parseURL("jdbc:metamatrix:BQT@mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302;version=4;txnAutoWrap=ON;partialResultsMode=YES", p);
        TestMMDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestMMDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("4"));
        TestMMDriver.assertTrue((boolean)p.getProperty("txnAutoWrap").equals("ON"));
        TestMMDriver.assertTrue((boolean)p.getProperty("partialResultsMode").equals("YES"));
        TestMMDriver.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302"));
        TestMMDriver.assertTrue((boolean)p.getProperty("version").equals("4"));
        TestMMDriver.assertEquals((int)6, (int)p.size());
    }

    public void testGetPropertyInfo1() throws Exception {
        DriverPropertyInfo[] info = this.drv.getPropertyInfo("jdbc:metamatrix:vdb@mm://localhost:12345", null);
        TestMMDriver.assertEquals((int)6, (int)info.length);
        TestMMDriver.assertEquals((boolean)true, (boolean)info[0].required);
        TestMMDriver.assertEquals((String)"VirtualDatabaseName", (String)info[0].name);
        TestMMDriver.assertEquals((String)"vdb", (String)info[0].value);
    }
}

