/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.TestAllResultsImpl;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class TestMMResultSet
extends TestCase {
    public static final int PROC_BATCH_SIZE = 100;

    public TestMMResultSet(String name) {
        super(name);
    }

    public void testNext1() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertEquals((String)" Actual doesn't match with expected. ", (Object)new Integer(0), (Object)new Integer(cs.getRow()));
        cs.close();
    }

    public void testNext2() throws SQLException {
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(1000);
        MMResultSet cs = this.helpExecuteQuery();
        int i = 0;
        while (cs.next()) {
            TestMMResultSet.assertEquals((String)" Actual doesn't match with expected. ", expected[i], (Object)cs.getCurrentRecord());
            ++i;
        }
        cs.close();
    }

    public void testNextBeyondEnd_fetchEqualsCount() throws Exception {
        this.helpTestNextBeyondResultSet(1000, 1000);
    }

    public void testNextBeyondEnd_fetchLessThanCount() throws Exception {
        this.helpTestNextBeyondResultSet(100, 1000);
    }

    public void testNextBeyondEnd_fetchLessThanCount1() throws Exception {
        this.helpTestNextBeyondResultSet(100, 101);
    }

    public void testNextBeyondEnd_fetchLessThanCountNonMultiple() throws Exception {
        this.helpTestNextBeyondResultSet(120, 1000);
    }

    public void testNextBeyondEnd_fetchGreaterThanCount() throws Exception {
        this.helpTestNextBeyondResultSet(300, 100);
    }

    public void testNextBeyondEnd_fetchGreaterThanCountNonMultiple() throws Exception {
        this.helpTestNextBeyondResultSet(310, 50);
    }

    public void testNextBeyondEnd_fetchGreaterThanCountNonMultiple2() throws Exception {
        this.helpTestNextBeyondResultSet(300, 110);
    }

    public void testNextBeyondEnd_fetchLessThanCount_ResultsBetweenFetchAndProcBatch() throws Exception {
        this.helpTestNextBeyondResultSet(30, 75);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helpTestNextBeyondResultSet(int fetchSize, int numRows) throws Exception {
        MMResultSet cs = this.helpExecuteQuery(fetchSize, numRows);
        try {
            Object lastRowValue = null;
            for (int rowNum = 1; rowNum <= numRows; ++rowNum) {
                TestMMResultSet.assertEquals((String)"Should return true before end cs.next()", (boolean)true, (boolean)cs.next());
            }
            lastRowValue = cs.getObject(1);
            for (int i = numRows + 1; i < numRows + 4; ++i) {
                TestMMResultSet.assertEquals((String)("Should return false when going past the end: " + i), (boolean)false, (boolean)cs.next());
                TestMMResultSet.assertEquals((String)("Is after last should be true: " + i), (boolean)true, (boolean)cs.isAfterLast());
            }
            cs.previous();
            TestMMResultSet.assertEquals((String)"Is last should be true", (boolean)true, (boolean)cs.isLast());
            TestMMResultSet.assertEquals((String)"Not on last row", (Object)lastRowValue, (Object)cs.getObject(1));
        }
        finally {
            cs.close();
        }
    }

    public void testBidirection() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertNotNull((Object)cs);
        cs.absolute(290);
        TestMMResultSet.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(290), cs.getCurrentRecord().get(0));
        cs.next();
        TestMMResultSet.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(291), cs.getCurrentRecord().get(0));
        cs.next();
        TestMMResultSet.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(292), cs.getCurrentRecord().get(0));
        cs.previous();
        TestMMResultSet.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(291), cs.getCurrentRecord().get(0));
        cs.next();
        TestMMResultSet.assertEquals((String)" Actual value doesn't match with expected one.", (Object)new Integer(292), cs.getCurrentRecord().get(0));
        cs.close();
    }

    public void testHasNext1() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertEquals((String)" hasNext() doesn't match expected value. ", (boolean)true, (boolean)cs.hasNext());
        cs.close();
    }

    public void testHasNext2() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(100);
        TestMMResultSet.assertEquals((String)" hasNext() doesn't match expected value. ", (boolean)true, (boolean)cs.hasNext());
        cs.close();
    }

    public void testHasNext3() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        for (int i = 0; cs.next() && i != 289; ++i) {
        }
        TestMMResultSet.assertEquals((String)" hasNext() doesn't match expected value. ", (boolean)true, (boolean)cs.hasNext());
        cs.close();
    }

    public void testHasNext4() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(1000);
        TestMMResultSet.assertTrue((!cs.hasNext() ? 1 : 0) != 0);
        cs.close();
    }

    public void testPrevious1() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(1000);
        while (cs.next()) {
        }
        TestMMResultSet.assertEquals((String)" current row doesn't match expected value. ", (int)0, (int)cs.getRow());
        int i = 1000;
        while (cs.previous()) {
            TestMMResultSet.assertEquals((String)" Actual doesn't match with expected. ", expected[i - 1], (Object)cs.getCurrentRecord());
            --i;
        }
        TestMMResultSet.assertEquals((String)" current row doesn't match expected value. ", (int)0, (int)cs.getRow());
        cs.close();
    }

    public void testPrevious2() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(290);
        TestMMResultSet.assertTrue((boolean)cs.previous());
        TestMMResultSet.assertEquals((String)" current row doesn't match expected value. ", (int)289, (int)cs.getRow());
        cs.close();
    }

    public void testPrevious3() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery(600, 10000);
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(10000);
        while (cs.next()) {
        }
        TestMMResultSet.assertEquals((String)" current row doesn't match expected value. ", (int)0, (int)cs.getRow());
        int i = 10000;
        while (cs.previous()) {
            TestMMResultSet.assertEquals((String)" Actual doesn't match with expected. ", expected[i - 1], (Object)cs.getCurrentRecord());
            --i;
        }
        TestMMResultSet.assertEquals((String)" current row doesn't match expected value. ", (int)0, (int)cs.getRow());
        cs.close();
    }

    public void testPrevious4() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery(50, 1000);
        List<Object>[] expected = TestAllResultsImpl.exampleResults1(1000);
        while (cs.next()) {
        }
        TestMMResultSet.assertEquals((String)" current row doesn't match expected value. ", (int)0, (int)cs.getRow());
        int i = 1000;
        while (cs.previous()) {
            TestMMResultSet.assertEquals((String)" Actual doesn't match with expected. ", expected[i - 1], (Object)cs.getCurrentRecord());
            --i;
        }
        TestMMResultSet.assertEquals((String)" current row doesn't match expected value. ", (int)0, (int)cs.getRow());
        cs.close();
    }

    public void testChangeDirection() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(291);
        cs.previous();
        TestMMResultSet.assertEquals((String)" current row doesn't match expected value. ", (int)290, (int)cs.getRow());
        cs.close();
    }

    public void testIsFirst() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        TestMMResultSet.assertTrue((boolean)cs.isFirst());
        cs.close();
    }

    public void testIsLast1() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        TestMMResultSet.assertTrue((!cs.isLast() ? 1 : 0) != 0);
        cs.close();
    }

    public void testIsLast2() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        for (int i = 0; cs.next() && i != 99; ++i) {
        }
        TestMMResultSet.assertTrue((!cs.isLast() ? 1 : 0) != 0);
        cs.close();
    }

    public void testIsLast3() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(1000);
        TestMMResultSet.assertTrue((boolean)cs.isLast());
        cs.close();
    }

    public void testIsBeforeFirst() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertTrue((boolean)cs.isBeforeFirst());
        cs.close();
    }

    public void testBeforeFirst() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)1, (int)cs.getRow());
        cs.beforeFirst();
        TestMMResultSet.assertTrue((boolean)cs.isBeforeFirst());
        cs.close();
    }

    public void testFirst() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)2, (int)cs.getRow());
        cs.first();
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)1, (int)cs.getRow());
        cs.close();
    }

    public void testAfterLast() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.afterLast();
        TestMMResultSet.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    public void testIsAfterLast1() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(1000);
        cs.next();
        TestMMResultSet.assertTrue((boolean)cs.isAfterLast());
        cs.close();
    }

    public void testIsAfterLast2() throws Exception {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertTrue((!cs.isAfterLast() ? 1 : 0) != 0);
        cs.close();
    }

    public void testAbsolute1() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)2, (int)cs.getRow());
        cs.absolute(1);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)1, (int)cs.getRow());
        cs.close();
    }

    public void testAbsolute2() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)2, (int)cs.getRow());
        cs.absolute(3);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)3, (int)cs.getRow());
        cs.close();
    }

    public void testAbsolute3() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)2, (int)cs.getRow());
        cs.absolute(100);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)100, (int)cs.getRow());
        cs.close();
    }

    public void testAbsolute4() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)2, (int)cs.getRow());
        cs.absolute(200);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)200, (int)cs.getRow());
        cs.close();
    }

    public void testAbsolute5() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        cs.next();
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)2, (int)cs.getRow());
        cs.absolute(-1);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)1000, (int)cs.getRow());
        cs.close();
    }

    public void testAbsolute6() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(1005);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)0, (int)cs.getRow());
        cs.close();
    }

    public void testRelative1() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(3);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)3, (int)cs.getRow());
        cs.relative(137);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)140, (int)cs.getRow());
        cs.close();
    }

    public void testRelative2() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(137);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)137, (int)cs.getRow());
        cs.relative(-133);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)4, (int)cs.getRow());
        cs.close();
    }

    public void testRelative3() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(137);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)137, (int)cs.getRow());
        cs.relative(-37);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)100, (int)cs.getRow());
        cs.close();
    }

    public void testRelative4() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(237);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)237, (int)cs.getRow());
        cs.relative(-200);
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)37, (int)cs.getRow());
        cs.close();
    }

    public void testGetRow1() throws SQLException {
        int i;
        MMResultSet cs = this.helpExecuteQuery();
        for (i = 0; cs.next() && i != 102; ++i) {
        }
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)(i + 1), (int)cs.getRow());
        cs.close();
    }

    public void testGetRow2() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)1, (int)cs.getRow());
        cs.close();
    }

    public void testGetRow3() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        for (int i = 0; cs.next() && i != 99; ++i) {
        }
        TestMMResultSet.assertEquals((String)" Current row number doesn't match with expected one.", (int)100, (int)cs.getRow());
        cs.close();
    }

    public void testGetCurrentRecord() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.absolute(103);
        TestMMResultSet.assertEquals((String)" Current record doesn't match with expected one.", (Object)new Integer(103), cs.getCurrentRecord().get(0));
        cs.close();
    }

    public void testClose() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertEquals((String)" Actual doesn't match with expected. ", (Object)new Integer(0), (Object)new Integer(cs.getRow()));
        cs.close();
    }

    public void testGetMetaData() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        List columnName = this.getBQTRSMetaData1a();
        List columnType = this.getBQTRSMetaData1b();
        List columnTypeName = this.getBQTRSMetaData1c();
        ResultSetMetaData rm = cs.getMetaData();
        TestMMResultSet.assertNotNull((Object)rm);
        for (int j = 1; j <= rm.getColumnCount(); ++j) {
            TestMMResultSet.assertEquals((String)" Actual doesn't match with expected. ", columnName.get(j - 1), (Object)rm.getColumnName(j));
            TestMMResultSet.assertEquals((String)" Actual doesn't match with expected. ", columnType.get(j - 1), (Object)new Integer(rm.getColumnType(j)));
            TestMMResultSet.assertEquals((String)" Actual doesn't match with expected. ", columnTypeName.get(j - 1), (Object)rm.getColumnTypeName(j));
        }
        cs.close();
    }

    public void testFindColumn() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        ResultSetMetaData rm = cs.getMetaData();
        TestMMResultSet.assertNotNull((Object)rm);
        TestMMResultSet.assertEquals((String)" Actual columnName doesn't match with expected. ", (int)1, (int)cs.findColumn("IntKey"));
        cs.close();
    }

    public void testFindNonExistentColumn() throws SQLException {
        MMResultSet rs = this.helpExecuteQuery();
        rs.next();
        try {
            rs.findColumn("BOGUS");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            rs.getObject("BOGUS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rs.close();
    }

    public void testGetStatement() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertNotNull((Object)cs.getStatement());
        cs.close();
    }

    public void testGetPlanDescription() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertNotNull((Object)cs);
        TestMMResultSet.assertNull((Object)cs.getStatement().getPlanDescription());
        cs.close();
    }

    public void testGetObject2() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        TestMMResultSet.assertEquals((String)" Actual value doesn't match with expected. ", (Object)new Integer(1), (Object)cs.getObject("IntKey"));
        cs.close();
    }

    public void testGetWarnings() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertNull((Object)cs.getWarnings());
        cs.close();
    }

    public void testGetCursorName() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertNull((Object)cs.getCursorName());
        cs.close();
    }

    public void testAllGetters() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        TestMMResultSet.assertEquals((String)" Actual value of getInt() doesn't match with expected one. ", (int)1, (int)cs.getInt("IntKey"));
        TestMMResultSet.assertEquals((String)" Actual value of getString() doesn't match with expected one. ", (String)"1", (String)cs.getString("IntKey"));
        TestMMResultSet.assertEquals((String)" Actual value of getFloat() doesn't match with expected one. ", (Object)new Float(1.0f), (Object)new Float(cs.getFloat("IntKey")));
        TestMMResultSet.assertEquals((String)" Actual value of getLong() doesn't match with expected one. ", (long)1L, (long)cs.getLong("IntKey"));
        TestMMResultSet.assertEquals((String)" Actual value of getDouble() doesn't match with expected one. ", (Object)new Double(1.0), (Object)new Double(cs.getDouble("IntKey")));
        TestMMResultSet.assertEquals((String)" Actual value of getByte() doesn't match with expected one. ", (byte)1, (byte)cs.getByte("IntKey"));
    }

    public void testWasNull() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        cs.next();
        TestMMResultSet.assertNotNull((Object)cs.getObject("IntKey"));
        TestMMResultSet.assertFalse((boolean)cs.wasNull());
    }

    public void testGetProcessingTime() throws SQLException {
        MMResultSet cs = this.helpExecuteQuery();
        TestMMResultSet.assertTrue((cs.getProcessingTime() == cs.getCompletedTimestamp().getTime() - 1L ? 1 : 0) != 0);
        cs.close();
    }

    private MMResultSet helpExecuteQuery() throws SQLException {
        return this.helpExecuteQuery(400, 1000);
    }

    private MMResultSet helpExecuteQuery(int fetchSize, int totalResults) throws SQLException {
        MMStatement statement = TestMMResultSet.createMockStatement();
        try {
            return TestAllResultsImpl.helpTestBatching(statement, fetchSize, Math.min(fetchSize, totalResults), totalResults);
        }
        catch (MetaMatrixProcessingException e) {
            throw new SQLException(e);
        }
        catch (InterruptedException e) {
            throw new SQLException(e);
        }
        catch (ExecutionException e) {
            throw new SQLException(e);
        }
    }

    static MMStatement createMockStatement() throws SQLException {
        MMStatement statement = (MMStatement)Mockito.mock(MMStatement.class);
        Mockito.stub((Object)statement.getDQP()).toReturn(Mockito.mock(ClientSideDQP.class));
        Mockito.stub((Object)statement.getResultSetType()).toReturn((Object)1004);
        TimeZone tz = TimeZone.getTimeZone("GMT-06:00");
        TimeZone serverTz = TimeZone.getTimeZone("GMT-05:00");
        Mockito.stub((Object)statement.getDefaultCalendar()).toReturn((Object)Calendar.getInstance(tz));
        Mockito.stub((Object)statement.getServerTimeZone()).toReturn((Object)serverTz);
        return statement;
    }

    private List getBQTRSMetaData1a() {
        ArrayList<String> results = new ArrayList<String>();
        results.add("IntKey");
        return results;
    }

    private List getBQTRSMetaData1b() {
        ArrayList<Integer> results = new ArrayList<Integer>();
        results.add(new Integer(4));
        return results;
    }

    private List getBQTRSMetaData1c() {
        ArrayList<String> results = new ArrayList<String>();
        results.add("integer");
        return results;
    }
}

