/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.ProcedureErrorInstructionException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.jdbc.MMSQLException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import junit.framework.TestCase;

public class TestMMSQLException
extends TestCase {
    public void testMMSQLException() {
        MMSQLException e = new MMSQLException();
        String sqlState = e.getSQLState();
        Throwable cause = e.getCause();
        int errorCode = e.getErrorCode();
        Throwable nestedException = e.getCause();
        SQLException nextException = e.getNextException();
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getSQLState() to return <null> but got \"" + sqlState + "\" instead."), (sqlState == null ? 1 : 0) != 0);
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getCause() to return <null> but got [" + (cause != null ? cause.getClass().getName() : "<unknown>") + "] instead."), (cause == null ? 1 : 0) != 0);
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getErrorCode() to return [0] but got [" + errorCode + "] instead."), (errorCode == 0 ? 1 : 0) != 0);
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getNestedException() to return <null> but got [" + (nestedException != null ? nestedException.getClass().getName() : "<unknown>") + "] instead."), (nestedException == null ? 1 : 0) != 0);
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getNextException() to return <null> but got a SQLException with message \"" + (nextException != null ? nextException.getMessage() : "") + "\" instead."), (nextException == null ? 1 : 0) != 0);
    }

    public void testCreateThrowable_01() {
        this.testCreateThrowable((Throwable)new CommunicationException("A test MM Communication Exception"), "08S01");
        this.testCreateThrowable(new ConnectException("A test connection attempt exception"), "08001");
        this.testCreateThrowable((Throwable)new ConnectionException("A test MM Connection Exception"), "08001");
        this.testCreateThrowable(new IOException("A test Generic java.io.IOException"), "08S01");
        this.testCreateThrowable(new MalformedURLException("A test java.net.MalformedURLException"), "08001");
        this.testCreateThrowable((Throwable)new MetaMatrixCoreException("A test Generic MM Core Exception"), "38000");
        this.testCreateThrowable((Throwable)new MetaMatrixException("A test MM Exception"), "38000");
        this.testCreateThrowable((Throwable)new MetaMatrixProcessingException("A test Generic MM Query Processing Exception"), "50000");
        this.testCreateThrowable((Throwable)new MetaMatrixRuntimeException("A test MM Runtime Exception"), "38000");
        this.testCreateThrowable((Throwable)new MMSQLException("A test Generic MM SQL Exception"), "38000");
        this.testCreateThrowable(new NoRouteToHostException("A test java.net.NoRouteToHostException"), "08001");
        this.testCreateThrowable(new NullPointerException("A test NPE"), "38000");
        this.testCreateThrowable((Throwable)new ProcedureErrorInstructionException("A test SQL Procedure Error exception"), "50001");
        this.testCreateThrowable(new SocketTimeoutException("A test socket timeout exception"), "08S01");
        this.testCreateThrowable(new UnknownHostException("A test connection attempt exception"), "08001");
    }

    public void testCreateThrowable_02() {
        this.testCreateThrowable((Throwable)new CommunicationException((Throwable)new ConnectException("A test java.net.ConnectException"), "Test Communication Exception with a ConnectException in it"), "08001");
        this.testCreateThrowable((Throwable)new CommunicationException((Throwable)new SocketException("A test java.net.SocketException"), "Test Communication Exception with a SocketException in it"), "08S01");
        this.testCreateThrowable((Throwable)new MetaMatrixException((Throwable)new SocketTimeoutException("A test java.net.SocketTimeoutException"), "Test MetaMatrixException with a SocketTimeoutException in it"), "08S01");
    }

    public void testCreateThrowable3() {
        MMSQLException e = this.testCreateThrowable((Throwable)new MetaMatrixCoreException((Throwable)new MetaMatrixRuntimeException((Throwable)new SocketTimeoutException("A test MM Invalid Session Exception"), "Test MetaMatrixRuntimeException with a InvalidSessionException in it"), "Test MM Core Exception with an MM Runtime Exception in it and an InvalidSessionException nested within"), "08S01");
        MMSQLException e1 = MMSQLException.create((Throwable)e, (String)"new message");
        TestMMSQLException.assertEquals((String)"new message", (String)e1.getMessage());
        this.testCreateThrowable(((MMSQLException)e1.getCause()).getCause(), "08S01");
    }

    private MMSQLException testCreateThrowable(Throwable ecause, String esqlState) {
        MMSQLException e = MMSQLException.create((Throwable)ecause);
        if (ecause.getClass() == MMSQLException.class) {
            ecause = null;
        }
        String sqlState = e.getSQLState();
        Throwable cause = e.getCause();
        int errorCode = e.getErrorCode();
        Throwable nestedException = e.getCause();
        SQLException nextException = e.getNextException();
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getSQLState() to return \"" + esqlState + "\" but got \"" + sqlState + "\" instead."), (sqlState.compareTo(esqlState) == 0 ? 1 : 0) != 0);
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getCause() to return [" + (ecause != null ? ecause.getClass().getName() : "<null>") + "] but got [" + (cause != null ? cause.getClass().getName() : "<unknown>") + "] instead."), (cause == ecause ? 1 : 0) != 0);
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getErrorCode() to return [0] but got [" + errorCode + "] instead."), (errorCode == 0 ? 1 : 0) != 0);
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getNestedException() to return [" + (ecause != null ? ecause.getClass().getName() : "<null>") + "] but got [" + (nestedException != null ? nestedException.getClass().getName() : "<unknown>") + "] instead."), (nestedException == ecause ? 1 : 0) != 0);
        TestMMSQLException.assertTrue((String)("Expected MMSQLException.getNextException() to return <null> but got a SQLException with message \"" + (nextException != null ? nextException.getMessage() : "") + "\" instead."), (nextException == null ? 1 : 0) != 0);
        return e;
    }

    public void testCreate() {
        MMSQLException exception = MMSQLException.create((Throwable)new Exception());
        TestMMSQLException.assertEquals((String)exception.getMessage(), (String)Exception.class.getName());
        TestMMSQLException.assertNotNull((Object)exception.getSQLState());
        TestMMSQLException.assertEquals((String)exception.getSQLState(), (String)"38000");
        TestMMSQLException.assertEquals((Object)exception, (Object)MMSQLException.create((Throwable)exception));
    }

    public void testCreateFromSQLException() {
        SQLException sqlexception = new SQLException("foo", "21");
        SQLException nested = new SQLException("bar");
        sqlexception.setNextException(nested);
        String message = "top level message";
        MMSQLException exception = MMSQLException.create((Throwable)sqlexception, (String)message);
        TestMMSQLException.assertEquals((String)exception.getMessage(), (String)message);
        TestMMSQLException.assertEquals((String)exception.getSQLState(), (String)sqlexception.getSQLState());
        TestMMSQLException.assertEquals((String)exception.getNextException().getMessage(), (String)sqlexception.getMessage());
        TestMMSQLException.assertEquals((String)exception.getNextException().getNextException().getMessage(), (String)nested.getMessage());
    }
}

