/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.jdbc.WrapperImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.sql.Wrapper;
import junit.framework.TestCase;

public class TestWrapperImpl
extends TestCase {
    public void testProxy() throws SQLException {
        final FooImpl fooImpl = new FooImpl();
        Foo proxy = (Foo)Proxy.newProxyInstance(TestWrapperImpl.class.getClassLoader(), new Class[]{Foo.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
                if (arg1.getName().equals("callMe")) {
                    return null;
                }
                try {
                    return arg1.invoke((Object)fooImpl, arg2);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        });
        proxy.callMe();
        TestWrapperImpl.assertFalse((boolean)fooImpl.wasCalled);
        proxy.unwrap(Foo.class).callMe();
        TestWrapperImpl.assertTrue((boolean)fooImpl.wasCalled);
        try {
            proxy.unwrap(String.class);
            TestWrapperImpl.fail((String)"expected exception");
        }
        catch (SQLException e) {
            TestWrapperImpl.assertEquals((String)"Wrapped object is not an instance of class java.lang.String", (String)e.getMessage());
        }
    }

    static class FooImpl
    extends WrapperImpl
    implements Foo {
        boolean wasCalled;

        FooImpl() {
        }

        @Override
        public void callMe() {
            this.wasCalled = true;
        }
    }

    static interface Foo
    extends Wrapper {
        public void callMe();
    }
}

