/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.api;

import com.metamatrix.admin.api.core.Admin;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.jdbc.EmbeddedDriver;
import com.metamatrix.jdbc.api.Connection;
import com.metamatrix.script.io.MetadataReader;
import com.metamatrix.script.io.ResultSetReader;
import com.metamatrix.script.io.StringArrayReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.Assert;

public class AbstractMMQueryTestCase {
    protected Connection internalConnection = null;
    protected ResultSet internalResultSet = null;
    protected Statement internalStatement = null;
    protected int updateCount = -1;
    protected String DELIMITER = "    ";

    @After
    public void tearDown() throws Exception {
        this.closeConnection();
    }

    public Connection getConnection(String vdb) {
        String propsFile = UnitTestUtil.getTestDataPath() + "/mmquery/mm.properties";
        return this.getConnection(vdb, propsFile);
    }

    public Admin getAdmin() {
        try {
            Assert.assertNotNull((Object)this.internalConnection);
            return this.internalConnection.getAdminAPI();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Connection getConnection(String vdb, String propsFile) {
        return this.getConnection(vdb, propsFile, "");
    }

    public Connection getConnection(String vdb, String propsFile, String addtionalStuff) {
        this.closeResultSet();
        this.closeStatement();
        this.closeConnection();
        try {
            this.internalConnection = AbstractMMQueryTestCase.createConnection(vdb, propsFile, addtionalStuff);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this.internalConnection;
    }

    public static Connection createConnection(String vdb, String propsFile, String addtionalStuff) throws SQLException {
        String url = "jdbc:metamatrix:" + vdb + "@" + propsFile + addtionalStuff;
        return (Connection)DriverManager.getConnection(url);
    }

    public boolean execute(String sql) {
        return this.execute(sql, new Object[0]);
    }

    public boolean execute(String sql, Object[] params) {
        this.closeResultSet();
        this.closeStatement();
        this.updateCount = -1;
        try {
            Assert.assertNotNull((Object)this.internalConnection);
            Assert.assertTrue((!this.internalConnection.isClosed() ? 1 : 0) != 0);
            boolean result = false;
            if (params != null) {
                if (sql.startsWith("exec ")) {
                    sql = sql.substring(5);
                    this.internalStatement = this.internalConnection.prepareCall("{?=call " + sql + "}");
                } else {
                    this.internalStatement = this.internalConnection.prepareStatement(sql);
                }
                this.setParameters((PreparedStatement)this.internalStatement, params);
                result = ((PreparedStatement)this.internalStatement).execute();
            } else {
                this.internalStatement = this.internalConnection.createStatement();
                result = this.internalStatement.execute(sql);
            }
            if (result) {
                this.internalResultSet = this.internalStatement.getResultSet();
            } else {
                this.updateCount = this.internalStatement.getUpdateCount();
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void setParameters(PreparedStatement stmt, Object[] params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
    }

    public void assertResultsSetEquals(File expected) {
        this.assertResultsSetEquals(this.internalResultSet, expected);
    }

    public void assertResultsSetEquals(ResultSet resultSet, File expected) {
        Assert.assertNotNull((Object)resultSet);
        BufferedReader resultReader = null;
        BufferedReader expectedReader = null;
        try {
            resultReader = new BufferedReader((Reader)new ResultSetReader(resultSet, this.DELIMITER));
            expectedReader = new BufferedReader(new FileReader(expected));
            this.compareResults(resultReader, expectedReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resultReader.close();
                expectedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void assertResultsSetEquals(String expected) {
        this.assertResultsSetEquals(this.internalResultSet, expected);
    }

    public void assertResultsSetEquals(ResultSet resultSet, String expected) {
        Assert.assertNotNull((Object)resultSet);
        BufferedReader resultReader = null;
        BufferedReader expectedReader = null;
        try {
            resultReader = new BufferedReader((Reader)new ResultSetReader(resultSet, this.DELIMITER));
            expectedReader = new BufferedReader(new StringReader(expected));
            this.compareResults(resultReader, expectedReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resultReader.close();
                expectedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void assertResults(String[] expected) {
        this.assertResultsSetEquals(expected);
    }

    public void assertResultsSetEquals(String[] expected) {
        this.assertResultsSetEquals(this.internalResultSet, expected);
    }

    public void assertResultsSetEquals(ResultSet resultSet, String[] expected) {
        Assert.assertNotNull((Object)resultSet);
        BufferedReader resultReader = null;
        BufferedReader expectedReader = null;
        try {
            resultReader = new BufferedReader((Reader)new ResultSetReader(resultSet, this.DELIMITER));
            expectedReader = new BufferedReader((Reader)new StringArrayReader(expected));
            this.compareResults(resultReader, expectedReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resultReader.close();
                expectedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void assertReaderEquals(Reader expected, Reader reader) {
        BufferedReader resultReader = null;
        BufferedReader expectedReader = null;
        try {
            expectedReader = new BufferedReader(expected);
            resultReader = new BufferedReader(reader);
            this.compareResults(resultReader, expectedReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resultReader.close();
                expectedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void assertResultsSetMetadataEquals(ResultSetMetaData metadata, File expected) {
        Assert.assertNotNull((Object)metadata);
        BufferedReader resultReader = null;
        BufferedReader expectedReader = null;
        try {
            resultReader = new BufferedReader((Reader)new MetadataReader(metadata, this.DELIMITER));
            expectedReader = new BufferedReader(new FileReader(expected));
            this.compareResults(resultReader, expectedReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resultReader.close();
                expectedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void assertResultsSetMetadataEquals(ResultSetMetaData metadata, String[] expected) {
        Assert.assertNotNull((Object)metadata);
        BufferedReader resultReader = null;
        BufferedReader expectedReader = null;
        try {
            resultReader = new BufferedReader((Reader)new MetadataReader(metadata, this.DELIMITER));
            expectedReader = new BufferedReader((Reader)new StringArrayReader(expected));
            this.compareResults(resultReader, expectedReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resultReader.close();
                expectedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    int compareResults(BufferedReader resultReader, BufferedReader expectedReader) throws IOException {
        int lineCount = 0;
        while (true) {
            ++lineCount;
            String resultLine = resultReader.readLine();
            String expectedLine = expectedReader.readLine();
            if (resultLine == null && expectedLine != null) {
                Assert.fail((String)("More expected result lines available than actual results, line=" + lineCount));
                return 1;
            }
            if (resultLine != null && expectedLine == null) {
                Assert.fail((String)("More actual results are available than expected results, line=" + lineCount + "\n" + resultLine));
                return -1;
            }
            if (resultLine == null && expectedLine == null) {
                return 0;
            }
            resultLine = resultLine.trim();
            expectedLine = expectedLine.trim();
            junit.framework.Assert.assertEquals((String)expectedLine, (String)resultLine);
        }
    }

    public void printResults() {
        this.printResults(this.internalResultSet);
    }

    public void printResults(ResultSet results) {
        this.printResults(results, false);
    }

    public void printResults(boolean comparePrint) {
        Assert.assertNotNull((Object)this.internalResultSet);
        this.printResults(this.internalResultSet, comparePrint);
    }

    public void walkResults() {
        Assert.assertNotNull((Object)this.internalResultSet);
        try {
            int columnCount = this.internalResultSet.getMetaData().getColumnCount();
            while (this.internalResultSet.next()) {
                for (int col = 1; col <= columnCount; ++col) {
                    this.internalResultSet.getObject(col);
                }
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void printResults(ResultSet results, boolean comparePrint) {
        if (results == null) {
            System.out.println("ResultSet is null");
            return;
        }
        try {
            int row = -1;
            BufferedReader in = new BufferedReader((Reader)new ResultSetReader(results, this.DELIMITER));
            String line = in.readLine();
            while (line != null) {
                ++row;
                if (comparePrint) {
                    line = line.replaceAll("\"", "\\\\\"");
                    System.out.println("\"" + line + "\",");
                } else {
                    System.out.println(line);
                }
                line = in.readLine();
            }
            System.out.println("Fetched " + row + " rows\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void assertUpdateCount(int expected) {
        Assert.assertEquals((long)expected, (long)this.updateCount);
    }

    public void assertRowCount(int expected) {
        int count = this.getRowCount();
        Assert.assertEquals((long)expected, (long)count);
    }

    public int getRowCount() {
        Assert.assertNotNull((Object)this.internalResultSet);
        try {
            int count = 0;
            while (this.internalResultSet.next()) {
                ++count;
            }
            return count;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void closeStatement() {
        this.closeResultSet();
        if (this.internalStatement != null) {
            try {
                this.internalStatement.close();
                this.internalStatement = null;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void closeResultSet() {
        if (this.internalResultSet != null) {
            try {
                this.internalResultSet.close();
                this.internalResultSet = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        block5: {
            this.closeStatement();
            try {
                if (this.internalConnection == null) break block5;
                try {
                    this.internalConnection.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.internalConnection = null;
            }
        }
    }

    public void print(String msg) {
        System.out.println(msg);
    }

    public void print(Throwable e) {
        e.printStackTrace();
    }

    protected void helpTest(String query, String[] expected, String vdb, String props, String urlProperties) {
        this.getConnection(vdb, props, urlProperties);
        this.executeAndAssertResults(query, expected);
        this.closeConnection();
    }

    protected void executeAndAssertResults(String query, String[] expected) {
        this.execute(query);
        if (expected != null) {
            this.assertResults(expected);
        } else {
            this.printResults();
        }
    }

    static {
        new EmbeddedDriver();
    }
}

