/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.api;

import com.metamatrix.jdbc.api.FakePlanNode;
import com.metamatrix.jdbc.api.PlanNode;
import com.metamatrix.jdbc.api.TestTextOutputVisitor;
import com.metamatrix.jdbc.api.tools.QueryPlanDisplayHelper;
import java.util.Arrays;
import java.util.Map;
import junit.framework.TestCase;

public class TestQueryPlanDisplayHelper
extends TestCase {
    public TestQueryPlanDisplayHelper(String name) {
        super(name);
    }

    private QueryPlanDisplayHelper loadHelper() throws Exception {
        QueryPlanDisplayHelper helper = new QueryPlanDisplayHelper();
        return helper;
    }

    public void testGetNameWNullType() throws Exception {
        FakePlanNode plan = (FakePlanNode)TestTextOutputVisitor.example2();
        Map nodeProps = plan.getProperties();
        nodeProps.put("type", null);
        QueryPlanDisplayHelper helper = this.loadHelper();
        String name = helper.getName((PlanNode)plan);
        TestQueryPlanDisplayHelper.assertEquals((String)"Node", (String)name);
    }

    public void testGetDescriptionWNullType() throws Exception {
        FakePlanNode plan = (FakePlanNode)TestTextOutputVisitor.example2();
        Map nodeProps = plan.getProperties();
        nodeProps.put("type", null);
        QueryPlanDisplayHelper helper = this.loadHelper();
        String desc = helper.getDescription((PlanNode)plan);
        TestQueryPlanDisplayHelper.assertEquals((String)"", (String)desc);
    }

    public void testGetNameNullDescription() throws Exception {
        QueryPlanDisplayHelper helper = this.loadHelper();
        FakePlanNode node = new FakePlanNode("Access", null);
        node.setProperty("sql", "SELECT A, B, C FROM MYTABLE");
        TestQueryPlanDisplayHelper.assertEquals((String)"Access [SELECT A, B, C FROM MYTABLE]", (String)helper.getName((PlanNode)node));
        node = new FakePlanNode("Join", null);
        node.setProperty("joinType", "LEFT OUTER JOIN");
        node.setProperty("joinCriteria", Arrays.asList("A.B = B.B"));
        TestQueryPlanDisplayHelper.assertEquals((String)"Join [LEFT OUTER JOIN ON A.B = B.B]", (String)helper.getName((PlanNode)node));
        node = new FakePlanNode("Project", null);
        node.setProperty("selectCols", Arrays.asList("a", "b", "c"));
        TestQueryPlanDisplayHelper.assertEquals((String)"Project [a, b, c]", (String)helper.getName((PlanNode)node));
    }

    public void testGetName() throws Exception {
        QueryPlanDisplayHelper helper = this.loadHelper();
        FakePlanNode node = new FakePlanNode("Access", "Access Node Description");
        node.setProperty("sql", "SELECT A, B, C FROM MYTABLE");
        TestQueryPlanDisplayHelper.assertEquals((String)"Access [Access Node Description]", (String)helper.getName((PlanNode)node));
    }
}

