/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.api;

import com.metamatrix.jdbc.api.DisplayHelper;
import com.metamatrix.jdbc.api.FakeDisplayHelper;
import com.metamatrix.jdbc.api.FakePlanNode;
import com.metamatrix.jdbc.api.PlanNode;
import com.metamatrix.jdbc.api.TextOutputVisitor;
import com.metamatrix.jdbc.api.tools.QueryPlanDisplayHelper;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestTextOutputVisitor
extends TestCase {
    public TestTextOutputVisitor(String name) {
        super(name);
    }

    public static PlanNode example1() {
        FakePlanNode n1 = new FakePlanNode("Relational Plan", "");
        ArrayList<String> outputCols = new ArrayList<String>();
        outputCols.add("Name (string)");
        outputCols.add("Year (integer)");
        outputCols.add("Age (integer)");
        n1.setProperty("outputCols", outputCols);
        FakePlanNode n2 = new FakePlanNode("Project", "Name, Year, YEAR(CURDATE()) - year AS Age");
        outputCols = new ArrayList();
        outputCols.add("Name (string)");
        outputCols.add("Year (integer)");
        n2.setProperty("outputCols", outputCols);
        FakePlanNode n3 = new FakePlanNode("Join", "Item JOIN History");
        outputCols = new ArrayList();
        outputCols.add("Name (string)");
        outputCols.add("Year (integer)");
        n3.setProperty("outputCols", outputCols);
        n3.setProperty("Join Type", "INNER JOIN");
        ArrayList<String> crits = new ArrayList<String>();
        crits.add("Item.ID = History.ID");
        n3.setProperty("Criteria", crits);
        TestTextOutputVisitor.connectNodes(n1, n2);
        TestTextOutputVisitor.connectNodes(n2, n3);
        return n1;
    }

    public static PlanNode example2() {
        FakePlanNode n = new FakePlanNode("test", "");
        n.setProperty("string", "string");
        n.setProperty("integer", new Integer(0));
        n.setProperty("boolean", Boolean.TRUE);
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("item1");
        list1.add("item2");
        list1.add("item3");
        n.setProperty("list<string>", list1);
        return n;
    }

    public static void connectNodes(FakePlanNode parent, FakePlanNode child) {
        parent.addChild(child);
        child.setParent(parent);
    }

    public void testTypicalExample() {
        PlanNode plan = TestTextOutputVisitor.example1();
        TextOutputVisitor v = new TextOutputVisitor((DisplayHelper)new FakeDisplayHelper(), 0);
        v.visit(plan);
    }

    public void testCommonTypes() {
        PlanNode plan = TestTextOutputVisitor.example2();
        TextOutputVisitor v = new TextOutputVisitor((DisplayHelper)new FakeDisplayHelper(), 0);
        v.visit(plan);
    }

    public void testNestedNode() {
        PlanNode plan = TestTextOutputVisitor.example2();
        plan.getProperties().put("nested", TestTextOutputVisitor.example1());
        TextOutputVisitor v = new TextOutputVisitor((DisplayHelper)new FakeDisplayHelper(), 0);
        v.visit(plan);
    }

    public void testLimitNode() {
        FakePlanNode node = new FakePlanNode("Limit", "");
        ArrayList<String> outputCols = new ArrayList<String>();
        outputCols.add("Name (string)");
        outputCols.add("Year (integer)");
        outputCols.add("Age (integer)");
        node.setProperty("outputCols", outputCols);
        node.setProperty("rowLimit", "100");
        TextOutputVisitor v = new TextOutputVisitor((DisplayHelper)new QueryPlanDisplayHelper(), 0);
        v.visit((PlanNode)node);
        TestTextOutputVisitor.assertEquals((String)"Limit [100]\n  + Output Columns:\n      1: Name (string)\n      2: Year (integer)\n      3: Age (integer)\n  + Row Limit: 100\n", (String)v.getText());
    }

    public void testOffsetNode() {
        FakePlanNode node = new FakePlanNode("Offset", "");
        ArrayList<String> outputCols = new ArrayList<String>();
        outputCols.add("Name (string)");
        outputCols.add("Year (integer)");
        outputCols.add("Age (integer)");
        node.setProperty("outputCols", outputCols);
        node.setProperty("rowOffset", "100");
        TextOutputVisitor v = new TextOutputVisitor((DisplayHelper)new QueryPlanDisplayHelper(), 0);
        v.visit((PlanNode)node);
        TestTextOutputVisitor.assertEquals((String)"Offset [100]\n  + Output Columns:\n      1: Name (string)\n      2: Year (integer)\n      3: Age (integer)\n  + Row Offset: 100\n", (String)v.getText());
    }
}

