/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.api;

import com.metamatrix.jdbc.api.DisplayHelper;
import com.metamatrix.jdbc.api.FakeDisplayHelper;
import com.metamatrix.jdbc.api.FakePlanNode;
import com.metamatrix.jdbc.api.PlanNode;
import com.metamatrix.jdbc.api.TestTextOutputVisitor;
import com.metamatrix.jdbc.api.XMLOutputVisitor;
import com.metamatrix.jdbc.api.tools.QueryPlanDisplayHelper;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestXMLOutputVisitor
extends TestCase {
    public TestXMLOutputVisitor(String name) {
        super(name);
    }

    public void testTypicalExample() {
        PlanNode plan = TestTextOutputVisitor.example1();
        XMLOutputVisitor v = new XMLOutputVisitor((DisplayHelper)new FakeDisplayHelper());
        v.visit(plan);
    }

    public void testCommonTypes() {
        PlanNode plan = TestTextOutputVisitor.example2();
        XMLOutputVisitor v = new XMLOutputVisitor((DisplayHelper)new FakeDisplayHelper());
        v.visit(plan);
    }

    public void testNestedNode() {
        PlanNode plan = TestTextOutputVisitor.example2();
        plan.getProperties().put("nested", TestTextOutputVisitor.example1());
        XMLOutputVisitor v = new XMLOutputVisitor((DisplayHelper)new FakeDisplayHelper());
        v.visit(plan);
    }

    public void testLimitNode() {
        FakePlanNode node = new FakePlanNode("Limit", "");
        ArrayList<String> outputCols = new ArrayList<String>();
        outputCols.add("Name (string)");
        outputCols.add("Year (integer)");
        outputCols.add("Age (integer)");
        node.setProperty("outputCols", outputCols);
        node.setProperty("rowLimit", "100");
        XMLOutputVisitor v = new XMLOutputVisitor((DisplayHelper)new QueryPlanDisplayHelper());
        v.visit((PlanNode)node);
        TestXMLOutputVisitor.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node name=\"Limit [100]\">\n  <properties>\n    <property name=\"Output Columns\">\n      <collection>\n        <value>Name (string)</value>\n        <value>Year (integer)</value>\n        <value>Age (integer)</value>\n      </collection>\n    </property>\n    <property name=\"Row Limit\" value=\"100\"/>\n  </properties>\n</node>\n", (String)v.getText());
    }

    public void testOffsetNode() {
        FakePlanNode node = new FakePlanNode("Offset", "");
        ArrayList<String> outputCols = new ArrayList<String>();
        outputCols.add("Name (string)");
        outputCols.add("Year (integer)");
        outputCols.add("Age (integer)");
        node.setProperty("outputCols", outputCols);
        node.setProperty("rowOffset", "100");
        XMLOutputVisitor v = new XMLOutputVisitor((DisplayHelper)new QueryPlanDisplayHelper());
        v.visit((PlanNode)node);
        TestXMLOutputVisitor.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node name=\"Offset [100]\">\n  <properties>\n    <property name=\"Output Columns\">\n      <collection>\n        <value>Name (string)</value>\n        <value>Year (integer)</value>\n        <value>Age (integer)</value>\n      </collection>\n    </property>\n    <property name=\"Row Offset\" value=\"100\"/>\n  </properties>\n</node>\n", (String)v.getText());
    }
}

