/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.util;

import com.metamatrix.jdbc.EmbeddedDriver;
import com.metamatrix.jdbc.MMDriver;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.net.URLEncoder;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.TestCase;

public class TestMMJDBCURL
extends TestCase {
    public final void testCredentials() throws Exception {
        String credentials = URLEncoder.encode("defaultToLogon,(system=BQT1 SQL Server 2000 Simple Cap,user=xyz,password=xyz)", "UTF-8");
        MMJDBCURL url = new MMJDBCURL("jdbc:metamatrix:QT_sqls2kds@mm://slwxp136:43100;credentials=" + credentials);
        Properties p = url.getProperties();
        TestMMJDBCURL.assertEquals((String)"defaultToLogon,(system=BQT1 SQL Server 2000 Simple Cap,user=xyz,password=xyz)", (String)p.getProperty("credentials"));
    }

    public void testJDBCURLWithProperties() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1;configFile=testdata/bqt/dqp_stmt_e2e.xmi;disableLocalTxn=true;autoFailover=false";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "1");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        expectedProperties.setProperty("disableLocalTxn", "true");
        expectedProperties.setProperty("autoFailover", "false");
        MMJDBCURL url = new MMJDBCURL(URL2);
        TestMMJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestMMJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestMMJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    public void testJDBCURLWithoutProperties() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345";
        MMJDBCURL url = new MMJDBCURL(URL2);
        TestMMJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestMMJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestMMJDBCURL.assertEquals((Object)new Properties(), (Object)url.getProperties());
    }

    public void testCaseConversion() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;VERSION=1;user=xyz;password=***;configFile=testdata/bqt/dqp_stmt_e2e.xmi";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        MMJDBCURL url = new MMJDBCURL(URL2);
        TestMMJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestMMJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestMMJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    public void testWithExtraSemicolons() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1;;;configFile=testdata/bqt/dqp_stmt_e2e.xmi;;";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "1");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        MMJDBCURL url = new MMJDBCURL(URL2);
        TestMMJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestMMJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestMMJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    public void testWithWhitespace() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345; version =1;user= xyz ;password=***; logLevel = 1 ; configFile=testdata/bqt/dqp_stmt_e2e.xmi ;";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "1");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        MMJDBCURL url = new MMJDBCURL(URL2);
        TestMMJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestMMJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestMMJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    public void testNoPropertyValue() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=;configFile=";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "");
        expectedProperties.setProperty("configFile", "");
        MMJDBCURL url = new MMJDBCURL(URL2);
        TestMMJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestMMJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestMMJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    public void testInvalidProtocol() {
        String URL2 = "jdbc:monkeymatrix:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1";
        try {
            new MMJDBCURL(URL2);
            TestMMJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoVDBName() {
        String URL2 = "jdbc:metamatrix:@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1";
        try {
            new MMJDBCURL(URL2);
            TestMMJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoAtSignInURL() {
        String URL2 = "jdbc:metamatrix:bqt!mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1";
        try {
            new MMJDBCURL(URL2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMoreThanOneAtSign() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;version=1;user=xy@;password=***;logLevel=1";
        try {
            new MMJDBCURL(URL2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoEqualsInProperty() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;version=1;user=xyz;password***;logLevel=1";
        try {
            new MMJDBCURL(URL2);
            TestMMJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMoreThanOneEqualsInProperty() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;version=1;user=xyz;password==***;logLevel=1";
        try {
            new MMJDBCURL(URL2);
            TestMMJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;version=1;user=xyz;password=***=;logLevel=1";
        try {
            new MMJDBCURL(URL2);
            TestMMJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;version=1;user=xyz;=password=***;logLevel=1";
        try {
            new MMJDBCURL(URL2);
            TestMMJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoKeyInProperty() {
        String URL2 = "jdbc:metamatrix:bqt@mm://localhost:12345;version=1;user=xyz;=***;logLevel=1";
        try {
            new MMJDBCURL(URL2);
            TestMMJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor() {
        MMJDBCURL url = new MMJDBCURL("myVDB", "mm://myhost:12345", null);
        TestMMJDBCURL.assertEquals((String)"jdbc:metamatrix:myVDB@mm://myhost:12345", (String)url.getJDBCURL());
        Properties props = new Properties();
        props.setProperty("user", "myuser");
        props.setProperty("password", "mypassword");
        props.put("ClieNTtOKeN", new Integer(1));
        url = new MMJDBCURL("myVDB", "mm://myhost:12345", props);
        TestMMJDBCURL.assertEquals((String)"jdbc:metamatrix:myVDB@mm://myhost:12345;user=myuser;password=mypassword", (String)url.getJDBCURL());
    }

    public void testConstructor_Exception() {
        try {
            new MMJDBCURL(null, "myhost", null);
            TestMMJDBCURL.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            new MMJDBCURL("  ", "myhost", null);
            TestMMJDBCURL.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            new MMJDBCURL("myVDB", null, null);
            TestMMJDBCURL.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            new MMJDBCURL("myVDB", "  ", null);
            TestMMJDBCURL.fail((String)"Should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNormalize() {
        Properties props = new Properties();
        props.setProperty("UsEr", "myuser");
        props.setProperty("pAssWOrD", "mypassword");
        props.put("ClieNTtOKeN", new Integer(1));
        MMJDBCURL.normalizeProperties((Properties)props);
        TestMMJDBCURL.assertEquals((String)"myuser", (String)props.getProperty("user"));
        TestMMJDBCURL.assertEquals((String)"mypassword", (String)props.getProperty("password"));
        TestMMJDBCURL.assertEquals((Object)new Integer(1), (Object)props.get("clientToken"));
    }

    public final void testEncodedPropertyProperties() throws Exception {
        String password = "=@#^&*()+!%$^%@#_-)_~{}||\\`':;,./<>?password has = & %";
        Properties props = new Properties();
        props.setProperty("UsEr", "foo");
        props.setProperty("PASswoRd", password);
        MMJDBCURL.normalizeProperties((Properties)props);
        TestMMJDBCURL.assertEquals((String)password, (String)props.getProperty("password"));
        TestMMJDBCURL.assertEquals((String)"foo", (String)props.getProperty("user"));
    }

    public final void testEncodedPropertyInURL() throws Exception {
        String password = "=@#^&*()+!%$^%@#_-)_~{}||\\`':;,./<>?password has = & %";
        String encPassword = URLEncoder.encode(password, "UTF-8");
        MMJDBCURL url = new MMJDBCURL("jdbc:metamatrix:QT_sqls2kds@mm://slwxp136:43100;PASswoRd=" + encPassword);
        Properties p = url.getProperties();
        TestMMJDBCURL.assertEquals((String)password, (String)p.getProperty("password"));
    }

    public void testDriverManagerException() {
        new MMDriver();
        new EmbeddedDriver();
        try {
            DriverManager.getConnection("jdbc:metamatrix:QT_Ora9DS@somefile");
        }
        catch (SQLException e) {
            TestMMJDBCURL.assertEquals((String)"This Path: mmfile:somefile used to locate mm.properties is invalid.  Please check your file system and correct your JDBC URL. source:somefile", (String)e.getMessage());
        }
        try {
            DriverManager.getConnection("jdbc:foo:QT_Ora9DS@mm://host:30000");
        }
        catch (SQLException e) {
            TestMMJDBCURL.assertTrue((boolean)e.getMessage().startsWith("No suitable driver"));
        }
    }

    public void testGetServerURL_NoProperties() {
        String result = new MMJDBCURL("jdbc:metamatrix:designtimecatalog@mm://slwxp172:44401;user=ddifranco;password=mm").getConnectionURL();
        TestMMJDBCURL.assertEquals((String)"mm://slwxp172:44401", (String)result);
    }

    public void testGetServerURL_Properties() {
        String result = new MMJDBCURL("jdbc:metamatrix:designtimecatalog@mm://slwxp172:44401;user=ddifranco;password=mm").getConnectionURL();
        TestMMJDBCURL.assertEquals((String)"mm://slwxp172:44401", (String)result);
    }

    public void testGetServerURL_PasswordProperties() throws Exception {
        String result = null;
        String srcURL = "jdbc:metamatrix:designtimecatalog@mm://slwxp172:44401;user=ddifranco;password=";
        String password = null;
        String tgtURL = "mm://slwxp172:44401";
        for (char ch = ' '; ch <= '~'; ch = (char)((char)(ch + 1))) {
            if (ch == 59 || ch == 61 || ch == 37) continue;
            password = ch + "mm";
            result = new MMJDBCURL(srcURL + URLEncoder.encode(password, "UTF-8")).getConnectionURL();
            TestMMJDBCURL.assertEquals((String)("Failed to obtain correct ServerURL when using password " + password), (String)tgtURL, (String)result);
        }
    }

    public void testGetServerURL_2Servers() {
        String result = new MMJDBCURL("jdbc:metamatrix:designtimecatalog@mm://slwxp172:44401,slabc123:12345;user=ddifranco;password=mm").getConnectionURL();
        TestMMJDBCURL.assertEquals((String)"mm://slwxp172:44401,slabc123:12345", (String)result);
    }
}

