/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;

class ModuleHelper {
    static Logger logger = Logger.getLogger("org.teiid.jdbc");

    ModuleHelper() {
    }

    static ServerConnection createFromModule(Properties info) throws ConnectionException, TeiidException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ModuleLoader callerModuleLoader = Module.getCallerModuleLoader();
            if (callerModuleLoader == null) {
                logger.fine(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20033, new Object[0]));
                ServerConnection serverConnection = (ServerConnection)ReflectionHelper.create((String)"org.teiid.transport.LocalServerConnection", Arrays.asList(info, PropertiesUtils.getBooleanProperty((Properties)info, (String)"useCallingThread", (boolean)true)), (ClassLoader)Thread.currentThread().getContextClassLoader());
                return serverConnection;
            }
            Module module = callerModuleLoader.loadModule(ModuleIdentifier.create((String)"org.jboss.teiid"));
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            ServerConnection serverConnection = (ServerConnection)ReflectionHelper.create((String)"org.teiid.transport.LocalServerConnection", Arrays.asList(info, PropertiesUtils.getBooleanProperty((Properties)info, (String)"useCallingThread", (boolean)true)), (ClassLoader)Thread.currentThread().getContextClassLoader());
            return serverConnection;
        }
        catch (ModuleLoadException e) {
            throw new ConnectionException(JDBCPlugin.Event.TEIID20008, e, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20008, new Object[0]));
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

