/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.api.objects;

import com.metamatrix.admin.api.objects.AdminOptions;
import junit.framework.TestCase;

public class TestAdminOptions
extends TestCase {
    public TestAdminOptions(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMMAdminOptions_1_Option() {
        int theOptions = 4;
        AdminOptions opts = new AdminOptions(theOptions);
        TestAdminOptions.assertTrue((boolean)opts.containsOption(theOptions));
    }

    public void testMMAdminOptions_2_Options() {
        int option_1 = 4;
        int option_2 = 2;
        AdminOptions opts = new AdminOptions(option_1);
        opts.addOption(option_2);
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_1));
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_2));
    }

    public void testMMAdminOptions_3_Options() {
        int option_1 = 4;
        int option_2 = 2;
        int option_3 = 1;
        AdminOptions opts = new AdminOptions(option_1);
        opts.addOption(option_2);
        opts.addOption(option_3);
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_1));
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_2));
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_3));
    }

    public void testMMAdminOptions_4_Options() {
        int option_1 = 4;
        int option_2 = 2;
        int option_3 = 1;
        int option_4 = 8;
        AdminOptions opts = new AdminOptions(option_1);
        opts.addOption(option_2);
        opts.addOption(option_3);
        opts.addOption(option_4);
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_1));
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_2));
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_3));
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_4));
    }

    public void testMMAdminOptions_Bogus_Added() {
        int option_1 = 4;
        int bogus = 0;
        AdminOptions opts = new AdminOptions(option_1);
        try {
            opts.addOption(bogus);
            TestAdminOptions.fail((String)("AdminOptions addOptions method took an invalid option: " + bogus));
        }
        catch (Exception err) {
            // empty catch block
        }
    }

    public void testMMAdminOptions_1_Option_DoesNotContain_2() {
        int option_1 = 4;
        int option_2 = 2;
        int option_3 = 1;
        AdminOptions opts = new AdminOptions(option_1);
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_1));
        TestAdminOptions.assertFalse((boolean)opts.containsOption(option_2));
        TestAdminOptions.assertFalse((boolean)opts.containsOption(option_3));
    }

    public void testMMAdminOptions_2_Option_DoesNotContain_1() {
        int option_1 = 4;
        int option_2 = 2;
        int option_3 = 1;
        AdminOptions opts = new AdminOptions(option_1);
        opts.addOption(option_2);
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_1));
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_2));
        TestAdminOptions.assertFalse((boolean)opts.containsOption(option_3));
    }

    public void testMMAdminOptions_ORed() {
        int option_1 = 4;
        int option_2 = 2;
        AdminOptions opts = new AdminOptions(option_1 | option_2);
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_1));
        TestAdminOptions.assertTrue((boolean)opts.containsOption(option_2));
    }

    public void testMMAdminOptions_Bogus_0() {
        int bogus = 0;
        try {
            new AdminOptions(bogus);
            TestAdminOptions.fail((String)("AdminOptions ctor took an invalid option: " + bogus));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMMAdminOptions_ORed_Bogus_Added() {
        int option_1 = 4;
        int option_2 = 2;
        int bogus = -1;
        AdminOptions opts = new AdminOptions(option_1 | option_2);
        try {
            opts.addOption(bogus);
            TestAdminOptions.fail((String)("AdminOptions addOptions method took an invalid option: " + bogus));
        }
        catch (Exception err) {
            // empty catch block
        }
    }

    public void testToStringOne() {
        int option_1 = 4;
        AdminOptions opts = new AdminOptions(option_1);
        TestAdminOptions.assertEquals((String)"[OnConflict_EXCEPTION]", (String)opts.toString());
    }

    public void testToStringTwo() {
        int option_1 = 4;
        int option_4 = 8;
        AdminOptions opts = new AdminOptions(option_1);
        opts.addOption(option_4);
        TestAdminOptions.assertEquals((String)"[OnConflict_EXCEPTION, BINDINGS_IGNORE_DECRYPT_ERROR]", (String)opts.toString());
    }

    public void testToStringAll() {
        int option_1 = 4;
        int option_2 = 2;
        int option_3 = 1;
        int option_4 = 8;
        AdminOptions opts = new AdminOptions(option_1);
        opts.addOption(option_2);
        opts.addOption(option_3);
        opts.addOption(option_4);
        TestAdminOptions.assertEquals((String)"[OnConflict_OVERWRITE, OnConflict_IGNORE, OnConflict_EXCEPTION, BINDINGS_IGNORE_DECRYPT_ERROR]", (String)opts.toString());
    }
}

