/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.admin.api.objects.ProcessObject;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.platform.socket.client.AdminApiServerDiscovery;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.platform.security.api.LogonResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class TestAdminApiServerDiscovery
extends TestCase {
    public void testFirewallHost() throws Exception {
        AdminApiServerDiscovery discovery = new AdminApiServerDiscovery();
        Properties p = new Properties();
        p.setProperty("AdminApiServerDiscovery.useUrlHost", Boolean.TRUE.toString());
        MMURL mmurl = new MMURL("foo", 1, false);
        discovery.init(mmurl, p);
        TestAdminApiServerDiscovery.assertEquals((int)1, (int)discovery.getKnownHosts().size());
        SocketServerInstance instance = (SocketServerInstance)Mockito.mock(SocketServerInstance.class);
        ServerAdmin serverAdmin = (ServerAdmin)Mockito.mock(ServerAdmin.class);
        ArrayList<ProcessObject> processes = new ArrayList<ProcessObject>();
        ProcessObject p1 = (ProcessObject)Mockito.mock(ProcessObject.class);
        Mockito.stub((Object)p1.isEnabled()).toReturn((Object)false);
        Mockito.stub((Object)p1.getPort()).toReturn((Object)5);
        processes.add(p1);
        ProcessObject p2 = (ProcessObject)Mockito.mock(ProcessObject.class);
        Mockito.stub((Object)p2.isEnabled()).toReturn((Object)true);
        Mockito.stub((Object)p2.getPort()).toReturn((Object)6);
        processes.add(p2);
        Mockito.stub((Object)serverAdmin.getProcesses("*")).toReturn(processes);
        Mockito.stub((Object)instance.getService(ServerAdmin.class)).toReturn((Object)serverAdmin);
        discovery.connectionSuccessful((HostInfo)discovery.getKnownHosts().get(0), instance);
        discovery.setLogonResult(new LogonResult());
        List knownHosts = discovery.getKnownHosts();
        TestAdminApiServerDiscovery.assertEquals((int)1, (int)knownHosts.size());
        HostInfo h = (HostInfo)knownHosts.get(0);
        TestAdminApiServerDiscovery.assertEquals((String)"foo", (String)h.getHostName());
        TestAdminApiServerDiscovery.assertEquals((int)6, (int)h.getPortNumber());
    }
}

