/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.exception.SingleInstanceCommunicationException;
import com.metamatrix.common.comm.platform.socket.client.ServerDiscovery;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceFactory;
import com.metamatrix.common.comm.platform.socket.client.UrlServerDiscovery;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.client.ResultsFuture;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class TestSocketServerConnection
extends TestCase {
    public void testSocketServerConnection_PropertiesClientHost() throws Throwable {
        Properties p = new Properties();
        SocketServerConnectionFactory.updateConnectionProperties((Properties)p);
        TestSocketServerConnection.assertTrue((boolean)p.containsKey("clientHostName"));
        TestSocketServerConnection.assertTrue((boolean)p.containsKey("clientIpAddress"));
    }

    public void testLogonFailsWithMultipleHosts() throws Exception {
        Properties p = new Properties();
        SocketServerInstanceFactory instanceFactory = new SocketServerInstanceFactory(){

            public SocketServerInstance getServerInstance(HostInfo info, boolean ssl) throws CommunicationException, IOException {
                throw new SingleInstanceCommunicationException();
            }
        };
        UrlServerDiscovery discovery = new UrlServerDiscovery(new MMURL("mm://host1:1,host2:2"));
        try {
            new SocketServerConnection(instanceFactory, false, (ServerDiscovery)discovery, p, null);
            TestSocketServerConnection.fail((String)"exception expected");
        }
        catch (CommunicationException e) {
            TestSocketServerConnection.assertEquals((String)"No valid host available. Attempted connections to: [host1:1, host2:2]", (String)e.getMessage());
        }
    }

    public void testLogon() throws Exception {
        SocketServerConnection connection = this.createConnection(null);
        TestSocketServerConnection.assertEquals((String)"00000000-0000-0001-0000-000000000001", (String)connection.getLogonResult().getSessionID().toString());
    }

    public void testRetry() throws Exception {
        SocketServerConnection connection = this.createConnection((Throwable)new SingleInstanceCommunicationException());
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        logon.ping();
    }

    public void testImmediateFail() throws Exception {
        SocketServerConnection connection = this.createConnection(new CommunicationException());
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        try {
            logon.ping();
            TestSocketServerConnection.fail((String)"expected exception");
        }
        catch (MetaMatrixComponentException metaMatrixComponentException) {
            // empty catch block
        }
    }

    private SocketServerConnection createConnection(Throwable throwException) throws CommunicationException, ConnectionException {
        return this.createConnection(throwException, new HostInfo("foo", 1));
    }

    private SocketServerConnection createConnection(final Throwable t, HostInfo hostInfo) throws CommunicationException, ConnectionException {
        Properties p = new Properties();
        UrlServerDiscovery discovery = new UrlServerDiscovery(new MMURL(hostInfo.getHostName(), hostInfo.getPortNumber(), false));
        SocketServerInstanceFactory instanceFactory = new SocketServerInstanceFactory(){

            public SocketServerInstance getServerInstance(HostInfo info, boolean ssl) throws CommunicationException, IOException {
                SocketServerInstance instance = (SocketServerInstance)Mockito.mock(SocketServerInstance.class);
                Mockito.stub((Object)instance.getCryptor()).toReturn((Object)new NullCryptor());
                Mockito.stub((Object)instance.getHostInfo()).toReturn((Object)info);
                FakeILogon logon = new FakeILogon();
                logon.t = t;
                Mockito.stub((Object)instance.getService(ILogon.class)).toReturn((Object)logon);
                Mockito.stub((Object)instance.isOpen()).toReturn((Object)true);
                return instance;
            }
        };
        SocketServerConnection connection = new SocketServerConnection(instanceFactory, false, (ServerDiscovery)discovery, p, null);
        return connection;
    }

    public void testIsSameInstance() throws Exception {
        SocketServerConnection conn = this.createConnection(null, new HostInfo("0.0.0.0", 1));
        SocketServerConnection conn1 = this.createConnection(null, new HostInfo("0.0.0.1", 1));
        ClientSideDQP dqp = (ClientSideDQP)conn.getService(ClientSideDQP.class);
        ClientSideDQP dqp1 = (ClientSideDQP)conn1.getService(ClientSideDQP.class);
        TestSocketServerConnection.assertFalse((boolean)SocketServerConnection.isSameInstance((Object)dqp, (Object)dqp1));
        TestSocketServerConnection.assertTrue((boolean)SocketServerConnection.isSameInstance((Object)dqp, (Object)dqp));
    }

    private static final class FakeILogon
    implements ILogon {
        Throwable t;

        private FakeILogon() {
        }

        public void assertIdentity(MetaMatrixSessionID sessionId) throws InvalidSessionException, MetaMatrixComponentException {
        }

        public ResultsFuture<?> logoff() throws InvalidSessionException, MetaMatrixComponentException {
            return null;
        }

        public LogonResult logon(Properties connectionProperties) throws LogonException, MetaMatrixComponentException {
            return new LogonResult(new MetaMatrixSessionID(1L), "fooUser", new Properties(), 1L, "fake");
        }

        public ResultsFuture<?> ping() throws InvalidSessionException, MetaMatrixComponentException {
            if (this.t != null) {
                MetaMatrixComponentException e = new MetaMatrixComponentException(this.t);
                this.t = null;
                throw e;
            }
            return null;
        }
    }
}

