/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.Handshake;
import com.metamatrix.common.comm.platform.socket.ObjectChannel;
import com.metamatrix.common.comm.platform.socket.client.ObjectChannelFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceImpl;
import com.metamatrix.dqp.client.ResultsFuture;
import com.metamatrix.platform.security.api.ILogon;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class TestSocketServerInstanceImpl
extends TestCase {
    public void testHandshakeTimeout() throws Exception {
        FakeObjectChannel channel = new FakeObjectChannel(Arrays.asList(new SocketTimeoutException()));
        try {
            this.createInstance(channel);
            TestSocketServerInstanceImpl.fail((String)"Exception expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private SocketServerInstanceImpl createInstance(ObjectChannelFactory channelFactory) throws CommunicationException, IOException {
        SocketServerInstanceImpl ssii = new SocketServerInstanceImpl(new HostInfo("0.0.0.0", 1), false, 1L);
        ssii.connect(channelFactory);
        return ssii;
    }

    public void testSuccessfulHandshake() throws Exception {
        FakeObjectChannel channel = new FakeObjectChannel(Arrays.asList(new Handshake(), new SocketTimeoutException()));
        SocketServerInstanceImpl instance = this.createInstance(channel);
        ILogon logon = (ILogon)instance.getService(ILogon.class);
        try {
            logon.logon(new Properties());
            TestSocketServerInstanceImpl.fail((String)"Exception expected");
        }
        catch (MetaMatrixComponentException e) {
            TestSocketServerInstanceImpl.assertTrue((boolean)(e.getCause().getCause() instanceof TimeoutException));
        }
    }

    public void testVersionMismatch() throws Exception {
        Handshake h = new Handshake();
        h.setVersion("foo");
        FakeObjectChannel channel = new FakeObjectChannel(Arrays.asList(h));
        try {
            this.createInstance(channel);
            TestSocketServerInstanceImpl.fail((String)"exception expected");
        }
        catch (CommunicationException e) {
            e.printStackTrace();
            TestSocketServerInstanceImpl.assertEquals((String)"Handshake failed due to version mismatch -- Client Version: 6.0, Server Version: foo", (String)e.getMessage());
        }
    }

    private static class FakeObjectChannel
    implements ObjectChannel,
    ObjectChannelFactory {
        List<Object> msgs = new ArrayList<Object>();
        List<? extends Object> readMsgs;
        int readCount;

        public FakeObjectChannel(List<? extends Object> readMsgs) {
            this.readMsgs = readMsgs;
        }

        public void close() {
        }

        public boolean isOpen() {
            return true;
        }

        public Future<?> write(Object msg) {
            this.msgs.add(msg);
            ResultsFuture result = new ResultsFuture();
            result.getResultsReceiver().receiveResults(null);
            return result;
        }

        public Object read() throws IOException, ClassNotFoundException {
            Object msg;
            if ((msg = this.readMsgs.get(this.readCount++)) instanceof IOException) {
                if (msg instanceof SocketTimeoutException) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw (IOException)msg;
            }
            return msg;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public ObjectChannel createObjectChannel(SocketAddress address, boolean ssl) throws IOException, CommunicationException {
            return this;
        }

        public int getSoTimeout() {
            return 1;
        }
    }
}

