/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.client.ExceptionUtil;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.client.ClientSideDQP;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public class TestSocketServiceRegistry
extends TestCase {
    public void testExceptionConversionNoException() throws Exception {
        Method m = ServerAdmin.class.getMethod("close", new Class[0]);
        Throwable t = ExceptionUtil.convertException((Method)m, (Throwable)new MetaMatrixComponentException());
        TestSocketServiceRegistry.assertTrue((boolean)(t instanceof MetaMatrixRuntimeException));
    }

    public void testAdminExceptionConversion() throws Exception {
        Method m = ServerAdmin.class.getMethod("getHosts", String.class);
        Throwable t = ExceptionUtil.convertException((Method)m, (Throwable)new MetaMatrixComponentException());
        TestSocketServiceRegistry.assertTrue((boolean)(t instanceof AdminException));
    }

    public void testComponentExceptionConversion() throws Exception {
        Method m = ClientSideDQP.class.getMethod("getMetadata", Long.TYPE);
        Throwable t = ExceptionUtil.convertException((Method)m, (Throwable)new NullPointerException());
        TestSocketServiceRegistry.assertTrue((boolean)(t instanceof MetaMatrixComponentException));
    }

    public void testXATransactionExceptionConversion() throws Exception {
        Method m = ClientSideDQP.class.getMethod("recover", Integer.TYPE);
        Throwable t = ExceptionUtil.convertException((Method)m, (Throwable)new MetaMatrixComponentException());
        TestSocketServiceRegistry.assertTrue((boolean)(t instanceof XATransactionException));
    }
}

