/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import com.metamatrix.common.lob.ByteLobChunkStream;
import com.metamatrix.common.lob.LobChunkInputStream;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.core.util.UnitTestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;

public class TestLobChunkInputStream
extends TestCase {
    public void testReadByteArray() throws Exception {
        File f = UnitTestUtil.getTestDataFile((String)"legal_notice.xml");
        ByteLobChunkStream chunkProducer = new ByteLobChunkStream((InputStream)new FileInputStream(f), 10);
        LobChunkInputStream stream = new LobChunkInputStream((LobChunkProducer)chunkProducer);
        String fileContents = this.readFile((InputStream)stream);
        TestLobChunkInputStream.assertEquals((String)this.readFile(f), (String)fileContents);
    }

    public void testGetCharacterContents() throws Exception {
        File f = UnitTestUtil.getTestDataFile((String)"legal_notice.xml");
        ByteLobChunkStream chunkProducer = new ByteLobChunkStream((InputStream)new FileInputStream(f), 10);
        LobChunkInputStream reader = new LobChunkInputStream((LobChunkProducer)chunkProducer);
        String fileContents = new String(reader.getByteContents());
        TestLobChunkInputStream.assertEquals((String)this.readFile(new FileInputStream(f)), (String)fileContents);
    }

    private String readFile(InputStream reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        int chr = reader.read();
        while (chr != -1) {
            sb.append((char)chr);
            chr = reader.read();
        }
        reader.close();
        return sb.toString();
    }

    private String readFile(File f) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileReader reader = new FileReader(f);
        int chr = reader.read();
        while (chr != -1) {
            sb.append((char)chr);
            chr = reader.read();
        }
        reader.close();
        return sb.toString();
    }
}

