/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import com.metamatrix.common.lob.ReaderInputStream;
import com.metamatrix.core.util.UnitTestUtil;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import junit.framework.TestCase;

public class TestReaderInputStream
extends TestCase {
    public void testUTF8() throws Exception {
        int value;
        FileInputStream fis = new FileInputStream(UnitTestUtil.getTestDataFile((String)"legal_notice.xml"));
        ReaderInputStream ris = new ReaderInputStream((Reader)new FileReader(UnitTestUtil.getTestDataFile((String)"legal_notice.xml")), Charset.forName("UTF-8"));
        do {
            value = fis.read();
            TestReaderInputStream.assertEquals((int)value, (int)ris.read());
        } while (value != -1);
    }

    public void testUTF16() throws Exception {
        String actual = "!?abc";
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), Charset.forName("UTF-16"), 1);
        byte[] result = new byte[actual.length() * 2 + 2];
        ris.read(result);
        String resultString = new String(result, Charset.forName("UTF-16"));
        TestReaderInputStream.assertEquals((String)resultString, (String)actual);
    }

    public void testASCII() throws Exception {
        String actual = "!?abc";
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), Charset.forName("US-ASCII"), 1);
        byte[] result = new byte[actual.length()];
        ris.read(result);
        String resultString = new String(result, Charset.forName("US-ASCII"));
        TestReaderInputStream.assertEquals((String)resultString, (String)actual);
    }
}

