/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.api.MMURL;
import java.util.List;
import junit.framework.TestCase;

public class TestMMURL
extends TestCase {
    public static final String REQUIRED_URL = "mm[s]://server1:port1[,server2:port2]";

    public TestMMURL(String name) {
        super(name);
    }

    public final void testMMURL() {
        String SERVER_URL = "mm://localhost:31000";
        TestMMURL.assertTrue((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        MMURL url = new MMURL(SERVER_URL);
        List hosts = url.getHostInfo();
        TestMMURL.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        TestMMURL.assertEquals((int)1, (int)hosts.size());
    }

    public final void testBogusProtocol() {
        String SERVER_URL = "foo://localhost:31000";
        TestMMURL.assertFalse((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        try {
            new MMURL(SERVER_URL);
            TestMMURL.fail((String)"MM URL passed non standard protocal fine");
        }
        catch (RuntimeException e) {
            TestMMURL.assertEquals((String)MMURL.INVALID_FORMAT_SERVER, (String)e.getMessage());
        }
    }

    public final void testBogusProtocol1() {
        String SERVER_URL = "foo://localhost:31000";
        TestMMURL.assertFalse((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        try {
            new MMURL(SERVER_URL);
            TestMMURL.fail((String)"MM URL passed non standard protocal fine");
        }
        catch (RuntimeException e) {
            TestMMURL.assertEquals((String)MMURL.INVALID_FORMAT_SERVER, (String)e.getMessage());
        }
    }

    public final void testMMURLSecure() {
        String SERVER_URL = "mms://localhost:31000";
        TestMMURL.assertTrue((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        MMURL url = new MMURL(SERVER_URL);
        List hosts = url.getHostInfo();
        TestMMURL.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        TestMMURL.assertEquals((int)1, (int)hosts.size());
    }

    public final void testMMURLBadProtocolMM() {
        String SERVER_URL = "mmm://localhost:31000";
        TestMMURL.assertFalse((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        try {
            new MMURL(SERVER_URL);
            TestMMURL.fail((String)"MMURL did not throw an exception");
        }
        catch (IllegalArgumentException e) {
            TestMMURL.assertEquals((String)MMURL.INVALID_FORMAT_SERVER, (String)e.getMessage());
        }
    }

    public final void testMMURLWrongSlash() {
        String SERVER_URL = "mm:\\\\localhost:31000";
        TestMMURL.assertFalse((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        try {
            new MMURL(SERVER_URL);
            TestMMURL.fail((String)"MMURL did not throw an exception");
        }
        catch (IllegalArgumentException e) {
            TestMMURL.assertEquals((String)MMURL.INVALID_FORMAT_SERVER, (String)e.getMessage());
        }
    }

    public final void testMMURLOneSlash() {
        String SERVER_URL = "mm:/localhost:31000";
        TestMMURL.assertFalse((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        try {
            new MMURL(SERVER_URL);
            TestMMURL.fail((String)"MMURL did not throw an exception");
        }
        catch (IllegalArgumentException e) {
            TestMMURL.assertEquals((String)MMURL.INVALID_FORMAT_SERVER, (String)e.getMessage());
        }
    }

    public final void testMMURLNoHost() {
        String SERVER_URL = "mm://:31000";
        TestMMURL.assertFalse((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        try {
            new MMURL(SERVER_URL);
            TestMMURL.fail((String)"MMURL did not throw an exception");
        }
        catch (IllegalArgumentException e) {
            TestMMURL.assertEquals((String)MMURL.INVALID_FORMAT_SERVER, (String)e.getMessage());
        }
    }

    public final void testMMURLNoHostAndPort() {
        String SERVER_URL = "mm://:";
        TestMMURL.assertFalse((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        try {
            new MMURL(SERVER_URL);
            TestMMURL.fail((String)"MMURL did not throw an exception");
        }
        catch (IllegalArgumentException e) {
            TestMMURL.assertEquals((String)MMURL.INVALID_FORMAT_SERVER, (String)e.getMessage());
        }
    }

    public final void testMMURLNoHostAndPort2() {
        String SERVER_URL = "mm://";
        TestMMURL.assertFalse((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        try {
            new MMURL(SERVER_URL);
            TestMMURL.fail((String)"MMURL did not throw an exception");
        }
        catch (IllegalArgumentException e) {
            TestMMURL.assertEquals((String)MMURL.INVALID_FORMAT_SERVER, (String)e.getMessage());
        }
    }

    public final void testMMURLBadPort() {
        String SERVER_URL = "mm://localhost:port";
        TestMMURL.assertFalse((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        try {
            new MMURL(SERVER_URL);
            TestMMURL.fail((String)"MMURL did not throw an Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public final void testMMURL2Hosts() {
        String SERVER_URL = "mm://localhost:31000,localhost:31001";
        TestMMURL.assertTrue((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        MMURL url = new MMURL(SERVER_URL);
        List hosts = url.getHostInfo();
        TestMMURL.assertNotNull((String)"MMURL should have 2 Host", (Object)hosts);
        TestMMURL.assertEquals((int)2, (int)hosts.size());
    }

    public final void testMMURL3Hosts() {
        String SERVER_URL = "mm://localhost:31000,localhost:31001,localhost:31002";
        TestMMURL.assertTrue((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        MMURL url = new MMURL(SERVER_URL);
        List hosts = url.getHostInfo();
        TestMMURL.assertNotNull((String)"MMURL should have 3 Host", (Object)hosts);
        TestMMURL.assertEquals((int)3, (int)hosts.size());
    }

    public final void testGetHostInfo() {
        String SERVER_URL = "mm://localhost:31000";
        TestMMURL.assertTrue((boolean)MMURL.isValidServerURL((String)SERVER_URL));
        MMURL url = new MMURL(SERVER_URL);
        TestMMURL.assertNotNull((Object)url.getHostInfo());
    }

    public final void testGetProtocolStandalone() {
        MMURL url = new MMURL("mm://localhost:31000");
        TestMMURL.assertNotNull((Object)url);
        TestMMURL.assertEquals((String)"mm://localhost:31000", (String)url.getAppServerURL());
    }

    public final void testHasMoreElements() {
        MMURL url = new MMURL("mm://localhost:31000,localhost:31001");
        TestMMURL.assertNotNull((Object)url);
        TestMMURL.assertFalse((boolean)url.getHostInfo().isEmpty());
    }

    public final void testNextElement() {
        MMURL url = new MMURL("mm://localhost:31000,localhost:31001");
        TestMMURL.assertEquals((int)2, (int)url.getHostInfo().size());
    }

    public final void testHostInfoEquals() {
        HostInfo expectedResults = new HostInfo("localhost", 31000);
        MMURL url = new MMURL("mm://localhost:31000");
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        TestMMURL.assertEquals((Object)expectedResults, (Object)actualResults);
    }

    public final void testWithEmbeddedSpaces() {
        HostInfo expectedResults = new HostInfo("localhost", 12345);
        MMURL url = new MMURL("mm://localhost : 12345");
        List hosts = url.getHostInfo();
        TestMMURL.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        TestMMURL.assertEquals((int)1, (int)hosts.size());
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        TestMMURL.assertEquals((Object)expectedResults, (Object)actualResults);
    }

    public final void testHostPortConstructor() {
        HostInfo expectedResults = new HostInfo("myhost", 12345);
        MMURL url = new MMURL("myhost", 12345, false);
        List hosts = url.getHostInfo();
        TestMMURL.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        TestMMURL.assertEquals((int)1, (int)hosts.size());
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        TestMMURL.assertEquals((Object)expectedResults, (Object)actualResults);
        TestMMURL.assertEquals((String)"mm://myhost:12345", (String)url.getAppServerURL());
    }

    public final void testHostPortConstructorSSL() {
        HostInfo expectedResults = new HostInfo("myhost", 12345);
        MMURL url = new MMURL("myhost", 12345, true);
        List hosts = url.getHostInfo();
        TestMMURL.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        TestMMURL.assertEquals((int)1, (int)hosts.size());
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        TestMMURL.assertEquals((Object)expectedResults, (Object)actualResults);
        TestMMURL.assertEquals((String)"mms://myhost:12345", (String)url.getAppServerURL());
    }
}

