/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.message;

import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.dqp.message.RequestMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;

public class TestRequestMessage
extends TestCase {
    public TestRequestMessage(String name) {
        super(name);
    }

    public static RequestMessage example() {
        RequestMessage message = new RequestMessage();
        message.setCallableStatement(true);
        message.setFetchSize(100);
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(new Integer(100));
        params.add(new Integer(200));
        params.add(new Integer(300));
        params.add(new Integer(400));
        message.setParameterValues(params);
        message.setPartialResults(true);
        message.setPreparedStatement(false);
        message.setSubmittedTimestamp(new Date(11111111L));
        message.setProcessingTimestamp(new Date(12345678L));
        message.setStyleSheet("myStyleSheet");
        message.setExecutionPayload((Serializable)((Object)"myExecutionPayload"));
        try {
            message.setTxnAutoWrapMode("ON");
        }
        catch (MetaMatrixProcessingException e) {
            throw new RuntimeException(e);
        }
        message.setValidationMode(true);
        message.setXMLFormat("xMLFormat");
        message.setShowPlan(true);
        message.setRowLimit(1313);
        return message;
    }

    public void testSerialize() throws Exception {
        RequestMessage copy = (RequestMessage)UnitTestUtil.helpSerialize((Serializable)TestRequestMessage.example());
        TestRequestMessage.assertTrue((boolean)copy.isCallableStatement());
        TestRequestMessage.assertEquals((int)100, (int)copy.getFetchSize());
        TestRequestMessage.assertNotNull((Object)copy.getParameterValues());
        TestRequestMessage.assertEquals((int)4, (int)copy.getParameterValues().size());
        TestRequestMessage.assertEquals((Object)new Integer(100), copy.getParameterValues().get(0));
        TestRequestMessage.assertEquals((Object)new Integer(200), copy.getParameterValues().get(1));
        TestRequestMessage.assertEquals((Object)new Integer(300), copy.getParameterValues().get(2));
        TestRequestMessage.assertEquals((Object)new Integer(400), copy.getParameterValues().get(3));
        TestRequestMessage.assertFalse((boolean)copy.isPreparedStatement());
        TestRequestMessage.assertEquals((Object)new Date(11111111L), (Object)copy.getSubmittedTimestamp());
        TestRequestMessage.assertEquals((Object)new Date(12345678L), (Object)copy.getProcessingTimestamp());
        TestRequestMessage.assertEquals((String)"myStyleSheet", (String)copy.getStyleSheet());
        TestRequestMessage.assertEquals((Object)"myExecutionPayload", (Object)copy.getExecutionPayload());
        TestRequestMessage.assertEquals((String)"ON", (String)copy.getTxnAutoWrapMode());
        TestRequestMessage.assertTrue((boolean)copy.getValidationMode());
        TestRequestMessage.assertEquals((String)"xMLFormat", (String)copy.getXMLFormat());
        TestRequestMessage.assertTrue((boolean)copy.getShowPlan());
        TestRequestMessage.assertEquals((int)1313, (int)copy.getRowLimit());
    }

    public void testInvalidTxnAutoWrap() {
        RequestMessage rm = new RequestMessage();
        try {
            rm.setTxnAutoWrapMode("foo");
            TestRequestMessage.fail((String)"exception expected");
        }
        catch (MetaMatrixProcessingException e) {
            TestRequestMessage.assertEquals((String)"'FOO' is an invalid transaction autowrap mode.", (String)e.getMessage());
        }
    }
}

