/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.api.exception;

import com.metamatrix.core.MetaMatrixCoreException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AdminException
extends MetaMatrixCoreException {
    public static final int NO_ERROR_CODE = 0;
    private int errorCode = 0;
    private List children;

    AdminException() {
    }

    AdminException(String msg) {
        super(msg);
    }

    AdminException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    AdminException(int code, String msg) {
        super(msg);
        this.errorCode = code;
    }

    AdminException(String msg, Throwable cause) {
        super(cause, msg);
    }

    AdminException(int code, String msg, Throwable cause) {
        super(cause, msg);
        this.errorCode = code;
    }

    public int getCode() {
        return this.errorCode;
    }

    public boolean hasErrorCode() {
        return this.errorCode != 0;
    }

    public boolean hasMultiple() {
        return this.children != null && this.children.size() > 0;
    }

    public List getChildren() {
        return this.children != null ? this.children : Collections.EMPTY_LIST;
    }

    public void addChild(AdminException child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public String getMessage() {
        return (this.errorCode != 0 ? "Error Code[" + this.errorCode + "] " : "") + super.getMessage();
    }
}

