/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.objects;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.Cache;
import com.metamatrix.admin.api.objects.ConnectorBinding;
import com.metamatrix.admin.api.objects.ConnectorType;
import com.metamatrix.admin.api.objects.DQP;
import com.metamatrix.admin.api.objects.Entitlement;
import com.metamatrix.admin.api.objects.ExtensionModule;
import com.metamatrix.admin.api.objects.Group;
import com.metamatrix.admin.api.objects.Host;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.Model;
import com.metamatrix.admin.api.objects.ProcessObject;
import com.metamatrix.admin.api.objects.PropertyDefinition;
import com.metamatrix.admin.api.objects.QueueWorkerPool;
import com.metamatrix.admin.api.objects.Request;
import com.metamatrix.admin.api.objects.Resource;
import com.metamatrix.admin.api.objects.Role;
import com.metamatrix.admin.api.objects.Session;
import com.metamatrix.admin.api.objects.SourceRequest;
import com.metamatrix.admin.api.objects.SystemObject;
import com.metamatrix.admin.api.objects.User;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public abstract class MMAdminObject
implements AdminObject,
Serializable {
    public static final long serialVersionUID = -8280437282118346149L;
    public static final String OBJECTS_PACKAGE = "com.metamatrix.admin.api.objects.";
    public static final int OBJECT_TYPE_CACHE = 0;
    public static final int OBJECT_TYPE_CONNECTOR_BINDING = 2;
    public static final int OBJECT_TYPE_CONNECTOR_TYPE = 3;
    public static final int OBJECT_TYPE_DQP = 4;
    public static final int OBJECT_TYPE_ENTITLEMENT = 5;
    public static final int OBJECT_TYPE_EXTENSION_MODULE = 6;
    public static final int OBJECT_TYPE_GROUP = 7;
    public static final int OBJECT_TYPE_HOST = 8;
    public static final int OBJECT_TYPE_LOG_CONFIGURATION = 9;
    public static final int OBJECT_TYPE_MODEL = 10;
    public static final int OBJECT_TYPE_PROCESS_OBJECT = 11;
    public static final int OBJECT_TYPE_PROPERTY_DEFINITION = 12;
    public static final int OBJECT_TYPE_QUEUE_WORKER_POOL = 13;
    public static final int OBJECT_TYPE_REQUEST = 14;
    public static final int OBJECT_TYPE_RESOURCE = 15;
    public static final int OBJECT_TYPE_ROLE = 16;
    public static final int OBJECT_TYPE_SESSION = 17;
    public static final int OBJECT_TYPE_SOURCE_REQUEST = 18;
    public static final int OBJECT_TYPE_SYSTEM_OBJECT = 19;
    public static final int OBJECT_TYPE_USER = 20;
    public static final int OBJECT_TYPE_VDB = 21;
    private static HashMap objectTypeMap = new HashMap();
    protected String identifier;
    protected String[] identifierParts;
    protected String name;
    private Properties props = new Properties();
    private Date created;
    private String createdBy = "<default>";
    private Date lastUpdated;
    private String lastUpdatedBy = "<default>";
    protected boolean deployed;
    protected boolean registered;
    protected boolean enabled;

    public MMAdminObject(String[] identifierParts) {
        if (identifierParts == null) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("AbstractAdminObject.0"));
        }
        if (identifierParts.length == 0) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("AbstractAdminObject.1"));
        }
        this.setIdentifier(identifierParts);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected static List buildIdentifierList(String identifier) {
        ArrayList<String> result = null;
        if (identifier.indexOf(124) != -1) {
            result = StringUtil.split((String)identifier, (String)DELIMITER);
        } else {
            result = new ArrayList<String>(1);
            result.add(identifier);
        }
        return result;
    }

    public static String[] buildIdentifierArray(String identifier) {
        List list = MMAdminObject.buildIdentifierList(identifier);
        String[] array = new String[list.size()];
        return list.toArray(array);
    }

    public static String getNameFromIdentifier(String identifier) {
        List list = MMAdminObject.buildIdentifierList(identifier);
        int nameComponentCount = list.size();
        if (nameComponentCount > 0) {
            return (String)list.get(nameComponentCount - 1);
        }
        return null;
    }

    public static String getParentName(String identifier) {
        List list = MMAdminObject.buildIdentifierList(identifier);
        int nameComponentCount = list.size();
        if (nameComponentCount > 1) {
            return (String)list.get(nameComponentCount - 2);
        }
        return identifier;
    }

    public static String buildIdentifier(String[] identifierParts) {
        StringBuffer results = new StringBuffer();
        int length = identifierParts.length;
        for (int i = 0; i < length - 1; ++i) {
            results.append(identifierParts[i]).append('|');
        }
        results.append(identifierParts[length - 1]);
        return results.toString();
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    public String getPropertiesAsString() {
        String results = "";
        if (this.props != null) {
            results = PropertiesUtils.prettyPrint((Properties)this.props);
        }
        return results;
    }

    public void setIdentifier(String[] identifierParts) {
        this.identifier = MMAdminObject.buildIdentifier(identifierParts);
        this.identifierParts = identifierParts;
        this.name = identifierParts[identifierParts.length - 1];
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getIdentifierArray() {
        return this.identifierParts;
    }

    public abstract String toString();

    public Date getCreatedDate() {
        return this.created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getLastChangedDate() {
        return this.lastUpdated;
    }

    public String getLastChangedBy() {
        return this.lastUpdatedBy;
    }

    @Override
    public String getPropertyValue(String name) {
        return this.props.getProperty(name);
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public Properties getProps() {
        return this.props;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public static int getObjectType(String className) throws AdminException {
        Integer codeInteger;
        if (className.indexOf(".") == -1) {
            className = OBJECTS_PACKAGE + className;
        }
        if ((codeInteger = (Integer)objectTypeMap.get(className)) == null) {
            String message = AdminPlugin.Util.getString("MMAdminObject.Unsupported_Admin_Object", new Object[]{className});
            throw new AdminProcessingException(message);
        }
        return codeInteger;
    }

    static {
        objectTypeMap.put(Cache.class.getName(), new Integer(0));
        objectTypeMap.put(ConnectorBinding.class.getName(), new Integer(2));
        objectTypeMap.put(ConnectorType.class.getName(), new Integer(3));
        objectTypeMap.put(DQP.class.getName(), new Integer(4));
        objectTypeMap.put(Entitlement.class.getName(), new Integer(5));
        objectTypeMap.put(ExtensionModule.class.getName(), new Integer(6));
        objectTypeMap.put(Group.class.getName(), new Integer(7));
        objectTypeMap.put(Host.class.getName(), new Integer(8));
        objectTypeMap.put(LogConfiguration.class.getName(), new Integer(9));
        objectTypeMap.put(Model.class.getName(), new Integer(10));
        objectTypeMap.put(ProcessObject.class.getName(), new Integer(11));
        objectTypeMap.put(PropertyDefinition.class.getName(), new Integer(12));
        objectTypeMap.put(QueueWorkerPool.class.getName(), new Integer(13));
        objectTypeMap.put(Request.class.getName(), new Integer(14));
        objectTypeMap.put(Resource.class.getName(), new Integer(15));
        objectTypeMap.put(Role.class.getName(), new Integer(16));
        objectTypeMap.put(Session.class.getName(), new Integer(17));
        objectTypeMap.put(SourceRequest.class.getName(), new Integer(18));
        objectTypeMap.put(SystemObject.class.getName(), new Integer(19));
        objectTypeMap.put(User.class.getName(), new Integer(20));
        objectTypeMap.put(VDB.class.getName(), new Integer(21));
    }
}

