/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.objects;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMModel;
import com.metamatrix.core.util.HashCodeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public final class MMVDB
extends MMAdminObject
implements VDB,
Comparable {
    public static final int STATUS_INCOMPLETE = 1;
    public static final int STATUS_INACTIVE = 2;
    public static final int STATUS_ACTIVE = 3;
    public static final int STATUS_DELETED = 4;
    static final String[] VDB_STATUS_NAMES = new String[]{"Incomplete", "Inactive", "Active", "Deleted"};
    private Collection models = new ArrayList();
    private short status;
    private Date versionedDate;
    private String versionedBy;
    private long uid;
    private boolean hasMaterializedViews;
    private int cachedHashcode = HashCodeUtil.hashCode((int)13, (Object)this.getIdentifier());
    private boolean hasWSDL;

    public MMVDB(String[] identifierParts) {
        super(identifierParts);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(AdminPlugin.Util.getString("MMVDB.MMVDB")).append(this.getIdentifier());
        result.append(AdminPlugin.Util.getString("MMVDB.status")).append(this.getState());
        result.append(AdminPlugin.Util.getString("MMVDB.versionedDate")).append(this.versionedDate);
        result.append(AdminPlugin.Util.getString("MMVDB.versionedBy")).append(this.versionedBy);
        result.append(AdminPlugin.Util.getString("MMVDB.properties")).append(this.getPropertiesAsString());
        result.append(AdminPlugin.Util.getString("MMVDB.models")).append(this.models);
        return result.toString();
    }

    public void addModel(MMModel mmModel) {
        this.models.add(mmModel);
    }

    @Override
    public Date getVersionedDate() {
        return this.versionedDate;
    }

    @Override
    public String getVersionedBy() {
        return this.versionedBy;
    }

    @Override
    public Collection getModels() {
        return this.models;
    }

    @Override
    public int getState() {
        return this.status;
    }

    @Override
    public String getStateAsString() {
        return VDB_STATUS_NAMES[this.status - 1];
    }

    @Override
    public String getName() {
        return this.identifierParts[0];
    }

    @Override
    public String getVDBVersion() {
        return this.identifierParts[1];
    }

    public void setVersionedDate(Date bound) {
        this.versionedDate = bound;
    }

    public void setVersionedBy(String boundBy) {
        this.versionedBy = boundBy;
    }

    public void setModels(Collection models) {
        this.models = models;
    }

    public void setStatus(short status) {
        this.status = status;
        this.setDeployed(status == 3 || status == 2);
        this.setEnabled(status == 3);
        this.setRegistered(status == 3 || status == 2 || status == 1);
    }

    public long getUID() {
        return this.uid;
    }

    public void setUID(long uid) {
        this.uid = uid;
    }

    @Override
    public boolean hasMaterializedViews() {
        return this.hasMaterializedViews;
    }

    public void setMaterializedViews(boolean hasMaterializedViews) {
        this.hasMaterializedViews = hasMaterializedViews;
    }

    @Override
    public boolean hasWSDL() {
        return this.hasWSDL;
    }

    public void setHasWSDL(boolean hasWSDL) {
        this.hasWSDL = hasWSDL;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MMVDB)) {
            return false;
        }
        MMVDB other = (MMVDB)obj;
        return this.identifier.equals(other.identifier);
    }

    public int hashCode() {
        return this.cachedHashcode;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof MMVDB)) {
            return -1;
        }
        MMVDB other = (MMVDB)obj;
        return this.identifier.compareTo(other.identifier);
    }
}

