/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.client;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.lang.reflect.Method;

public class ExceptionUtil {
    public static Throwable convertException(Method method, Throwable exception) {
        boolean canThrowXATransactionException = false;
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        for (int i = 0; i < exceptionClasses.length; ++i) {
            if (exception.getClass().isAssignableFrom(exceptionClasses[i])) {
                return exception;
            }
            if (MetaMatrixComponentException.class.isAssignableFrom(exceptionClasses[i])) {
                return new MetaMatrixComponentException(exception);
            }
            if (AdminException.class.isAssignableFrom(exceptionClasses[i])) {
                return new AdminComponentException(exception);
            }
            canThrowXATransactionException |= XATransactionException.class.isAssignableFrom(exceptionClasses[i]);
        }
        if (canThrowXATransactionException) {
            return new XATransactionException(exception);
        }
        if (RuntimeException.class.isAssignableFrom(exception.getClass())) {
            return exception;
        }
        return new MetaMatrixRuntimeException(exception);
    }
}

