/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.api;

import com.metamatrix.common.util.NetUtils;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.HashCodeUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostInfo {
    private String hostName;
    private int portNumber = 0;
    private InetAddress inetAddress;

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.inetAddress != null) {
            return this.inetAddress;
        }
        return NetUtils.resolveHostByName((String)this.hostName);
    }

    public HostInfo(String host, int port) {
        ArgCheck.isNotNull((Object)host);
        this.hostName = host.toLowerCase();
        this.portNumber = port;
        try {
            InetAddress addr = NetUtils.resolveHostByName((String)this.hostName);
            if (addr.getHostAddress().equalsIgnoreCase(this.hostName)) {
                this.inetAddress = addr;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.hostName).append(":").append(this.portNumber);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HostInfo)) {
            return false;
        }
        HostInfo hostInfo = (HostInfo)obj;
        return this.hostName.equals(hostInfo.getHostName()) && this.portNumber == hostInfo.getPortNumber();
    }

    public int hashCode() {
        int hc = HashCodeUtil.hashCode((int)0, (Object)this.hostName);
        return HashCodeUtil.hashCode((int)hc, (int)this.portNumber);
    }
}

