/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.api;

import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class MMURL {
    public static final String DOT_DELIMITER = ".";
    public static final String DOUBLE_SLASH_DELIMITER = "//";
    public static final String COMMA_DELIMITER = ",";
    public static final String COLON_DELIMITER = ":";
    public static final String BACKSLASH_DELIMITER = "\\";
    public static final String DEFAULT_PROTOCOL = "mm://";
    public static final String SECURE_PROTOCOL = "mms://";
    public static final String FORMAT_SERVER = "mm[s]://server1:port1[,server2:port2]";
    public static final String INVALID_FORMAT_SERVER = CommPlatformPlugin.Util.getString("MMURL.INVALID_FORMAT", new Object[]{"mm[s]://server1:port1[,server2:port2]"});
    private String appServerURL;
    private List<HostInfo> hosts = new ArrayList<HostInfo>();
    private boolean usingSSL = false;

    public MMURL(String serverURL) {
        this.appServerURL = serverURL;
        if (!this.hasValidURLProtocol(serverURL)) {
            throw new IllegalArgumentException(INVALID_FORMAT_SERVER);
        }
        this.usingSSL = this.isSecureProtocol(this.appServerURL);
        this.parseURL(serverURL, INVALID_FORMAT_SERVER);
    }

    public MMURL(String host, int port, boolean secure) {
        this.usingSSL = secure;
        this.hosts.add(new HostInfo(host, port));
    }

    public static boolean isValidServerURL(String serverURL) {
        boolean valid = true;
        try {
            new MMURL(serverURL);
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    private boolean isSecureProtocol(String url) {
        return url.toLowerCase().startsWith(SECURE_PROTOCOL);
    }

    private boolean hasValidURLProtocol(String url) {
        return url != null && (url.startsWith(DEFAULT_PROTOCOL) || url.startsWith(SECURE_PROTOCOL));
    }

    public List<HostInfo> getHostInfo() {
        return this.hosts;
    }

    public String getHosts() {
        StringBuffer hostList = new StringBuffer("");
        if (this.hosts != null) {
            Iterator<HostInfo> iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo element = iterator.next();
                hostList.append(element.getHostName());
                if (!iterator.hasNext()) continue;
                hostList.append(COMMA_DELIMITER);
            }
        }
        return hostList.toString();
    }

    public String getPorts() {
        StringBuffer portList = new StringBuffer("");
        if (this.hosts != null) {
            Iterator<HostInfo> iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo element = iterator.next();
                portList.append(element.getPortNumber());
                if (!iterator.hasNext()) continue;
                portList.append(COMMA_DELIMITER);
            }
        }
        return portList.toString();
    }

    private void parseURL(String url, String exceptionMessage) {
        String serverURL;
        int urlProtocolIndex = url.indexOf(DOUBLE_SLASH_DELIMITER);
        if (urlProtocolIndex > 0) {
            serverURL = url.substring(urlProtocolIndex + 2);
            if (serverURL == null || serverURL.equals("")) {
                throw new IllegalArgumentException(exceptionMessage);
            }
        } else {
            throw new IllegalArgumentException(exceptionMessage);
        }
        this.parseServerURL(serverURL, exceptionMessage);
    }

    private void parseServerURL(String serverURL, String exceptionMessage) {
        StringTokenizer st = new StringTokenizer(serverURL, COMMA_DELIMITER);
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        while (st.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken(), COLON_DELIMITER);
            try {
                int portNumber;
                String host = st2.nextToken().trim();
                String port = st2.nextToken().trim();
                if (host.equals("")) {
                    throw new IllegalArgumentException("hostname can't be empty");
                }
                try {
                    portNumber = Integer.parseInt(port);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("port must be numeric:" + port);
                }
                if (portNumber < 0 || portNumber > 65535) {
                    throw new IllegalArgumentException("port out of range:" + portNumber);
                }
                HostInfo hostInfo = new HostInfo(host, portNumber);
                this.hosts.add(hostInfo);
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException(exceptionMessage);
            }
            catch (NullPointerException ne) {
                throw new IllegalArgumentException(exceptionMessage);
            }
        }
    }

    public String getAppServerURL() {
        if (this.appServerURL == null) {
            StringBuffer sb = new StringBuffer();
            if (this.usingSSL) {
                sb.append(SECURE_PROTOCOL);
            } else {
                sb.append(DEFAULT_PROTOCOL);
            }
            Iterator<HostInfo> iter = this.hosts.iterator();
            while (iter.hasNext()) {
                HostInfo host = iter.next();
                sb.append(host.getHostName());
                sb.append(COLON_DELIMITER);
                sb.append(host.getPortNumber());
                if (!iter.hasNext()) continue;
                sb.append(COMMA_DELIMITER);
            }
            this.appServerURL = sb.toString();
        }
        return this.appServerURL;
    }

    public String toString() {
        return this.getAppServerURL();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MMURL)) {
            return false;
        }
        MMURL url = (MMURL)obj;
        return this.appServerURL.equals(url.getAppServerURL());
    }

    public int hashCode() {
        return this.appServerURL.hashCode();
    }

    public boolean isUsingSSL() {
        return this.usingSSL;
    }

    public static interface CONNECTION {
        public static final String PRODUCT_NAME = "productName";
        public static final String CLIENT_IP_ADDRESS = "clientIpAddress";
        public static final String CLIENT_HOSTNAME = "clientHostName";
        public static final String AUTO_FAILOVER = "autoFailover";
        public static final String DISCOVERY_STRATEGY = "discoveryStategy";
        public static final String SERVER_URL = "serverURL";
        public static final String NON_SECURE_PROTOCOL = "mm";
        public static final String SECURE_PROTOCOL = "mms";
        public static final String APP_NAME = "ApplicationName";
        public static final String USER_NAME = "user";
        public static final String PASSWORD = "password";
        public static final String CLIENT_TOKEN_PROP = "clientToken";
    }

    public static interface JDBC {
        public static final String VDB_NAME = "VirtualDatabaseName";
        public static final String VDB_VERSION = "VirtualDatabaseVersion";
        public static final String VERSION = "version";
        public static final String CREDENTIALS = "credentials";
    }
}

