/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.exception;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ExceptionHolder
implements Externalizable {
    private String message;
    private String className;
    private boolean isProcessingException;
    private Throwable exception;

    public ExceptionHolder() {
    }

    public ExceptionHolder(Throwable exception) {
        this.exception = exception;
        this.isProcessingException = exception instanceof MetaMatrixProcessingException;
        this.className = exception.getClass().getName();
        this.message = exception.getMessage();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.isProcessingException = in.readBoolean();
        this.message = (String)in.readObject();
        this.exception = (Throwable)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeBoolean(this.isProcessingException);
        out.writeObject(this.message);
        out.writeObject(this.exception);
    }

    public Throwable convertException() {
        if (this.exception != null) {
            return this.exception;
        }
        if (this.isProcessingException) {
            return new MetaMatrixProcessingException(CommPlatformPlugin.Util.getString("ExceptionHolder.converted_exception", new Object[]{this.className, this.message}));
        }
        return new MetaMatrixComponentException(CommPlatformPlugin.Util.getString("ExceptionHolder.converted_exception", new Object[]{this.className, this.message}));
    }
}

