/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.client;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;

public class ServerAdminFactory {
    private static final int BOUNCE_WAIT = 2000;
    public static final String DEFAULT_APPLICATION_NAME = "Admin";
    private static ServerAdminFactory instance = new ServerAdminFactory();

    private ServerAdminFactory() {
    }

    public static ServerAdminFactory getInstance() {
        return instance;
    }

    public ServerAdmin createAdmin(String userName, char[] password, String serverURL) throws AdminException {
        return this.createAdmin(userName, password, serverURL, DEFAULT_APPLICATION_NAME);
    }

    public ServerAdmin createAdmin(String userName, char[] password, String serverURL, String applicationName) throws AdminException {
        if (userName == null || userName.trim().length() == 0) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("ERR.014.001.0099"));
        }
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("ERR.014.001.00100"));
        }
        Properties p = new Properties();
        p.setProperty("ApplicationName", applicationName);
        p.setProperty("user", userName);
        p.setProperty("password", new String(password));
        p.setProperty("serverURL", serverURL);
        return this.createAdmin(p);
    }

    public ServerAdmin createAdmin(Properties p) throws AdminComponentException, AdminException {
        p.setProperty("productName", "Platform");
        ServerAdmin serverAdmin = (ServerAdmin)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServerAdmin.class}, (InvocationHandler)new ReconnectingProxy(p));
        serverAdmin.getSystem();
        return serverAdmin;
    }

    private static final class ReconnectingProxy
    implements InvocationHandler {
        private ServerAdmin target;
        private SocketServerConnection registry;
        private Properties p;
        private boolean closed;

        public ReconnectingProxy(Properties p) {
            this.p = p;
        }

        private synchronized ServerAdmin getTarget() throws AdminComponentException, CommunicationException {
            if (this.closed) {
                throw new AdminComponentException(CommPlatformPlugin.Util.getString("ERR.014.001.0001"));
            }
            if (this.target != null && this.registry.isOpen()) {
                return this.target;
            }
            try {
                this.registry = SocketServerConnectionFactory.getInstance().createConnection(this.p);
            }
            catch (ConnectionException e) {
                throw new AdminComponentException(e.getMessage());
            }
            this.target = this.registry.getService(ServerAdmin.class);
            return this.target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("close")) {
                this.close();
                return null;
            }
            CommunicationException t = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    return method.invoke((Object)this.getTarget(), args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                catch (CommunicationException e) {
                    t = e;
                    continue;
                }
            }
            if (method.getName().endsWith("bounceSystem")) {
                this.bounceSystem((Boolean)args[1]);
                return null;
            }
            throw t;
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.registry != null) {
                this.registry.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bounceSystem(boolean waitUntilDone) {
            if (waitUntilDone) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    throw new MetaMatrixRuntimeException((Throwable)e);
                }
                for (int i = 0; i < 15; ++i) {
                    try {
                        this.getTarget().getSystem();
                        continue;
                    }
                    catch (Exception e) {
                        try {
                            Thread.sleep(2000L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            throw new MetaMatrixRuntimeException((Throwable)e2);
                        }
                    }
                    finally {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            throw new MetaMatrixRuntimeException((Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

