/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.objects.ProcessObject;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.comm.platform.socket.client.UrlServerDiscovery;
import com.metamatrix.platform.security.api.LogonResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class AdminApiServerDiscovery
extends UrlServerDiscovery {
    public static final String USE_URL_HOST = "AdminApiServerDiscovery.useUrlHost";
    private volatile List<HostInfo> knownHosts;
    private volatile boolean discoveredHosts;
    private volatile boolean authenticated;
    private HostInfo lastHostInfo;
    private SocketServerInstance lastServerInstance;
    private boolean useUrlHost;

    @Override
    public List<HostInfo> getKnownHosts() {
        if (!this.discoveredHosts) {
            return super.getKnownHosts();
        }
        return this.knownHosts;
    }

    @Override
    public void init(MMURL url, Properties p) {
        super.init(url, p);
        this.useUrlHost = Boolean.valueOf(p.getProperty(USE_URL_HOST));
    }

    @Override
    public synchronized void connectionSuccessful(HostInfo info, SocketServerInstance instance) {
        super.connectionSuccessful(info, instance);
        this.lastHostInfo = info;
        this.lastServerInstance = instance;
        this.discoverHosts();
    }

    private synchronized void discoverHosts() {
        if (this.discoveredHosts || !this.authenticated) {
            return;
        }
        ServerAdmin serverAdmin = this.lastServerInstance.getService(ServerAdmin.class);
        try {
            Collection processes = serverAdmin.getProcesses("*");
            this.knownHosts = new ArrayList<HostInfo>(processes.size());
            for (ProcessObject processObject : processes) {
                if (!processObject.isEnabled()) continue;
                this.knownHosts.add(new HostInfo(this.useUrlHost ? this.lastHostInfo.getHostName() : processObject.getInetAddress().getHostName(), processObject.getPort()));
            }
            this.discoveredHosts = true;
        }
        catch (AdminException adminException) {
            // empty catch block
        }
    }

    @Override
    public boolean setLogonResult(LogonResult result) {
        this.authenticated = true;
        this.discoverHosts();
        return this.discoveredHosts;
    }
}

